// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> Cluster aks patch upgrade history properties. </summary>
    public partial class ClusterAksPatchUpgradeHistoryProperties : ClusterUpgradeHistoryProperties
    {
        /// <summary> Initializes a new instance of <see cref="ClusterAksPatchUpgradeHistoryProperties"/>. </summary>
        /// <param name="utcTime"> Time when created this upgrade history. </param>
        /// <param name="upgradeResult"> Result of this upgrade. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="utcTime"/> is null. </exception>
        public ClusterAksPatchUpgradeHistoryProperties(string utcTime, ClusterUpgradeHistoryUpgradeResultType upgradeResult) : base(utcTime, upgradeResult)
        {
            Argument.AssertNotNull(utcTime, nameof(utcTime));

            UpgradeType = ClusterUpgradeHistoryType.AKSPatchUpgrade;
        }

        /// <summary> Initializes a new instance of <see cref="ClusterAksPatchUpgradeHistoryProperties"/>. </summary>
        /// <param name="upgradeType"> Type of upgrade. </param>
        /// <param name="utcTime"> Time when created this upgrade history. </param>
        /// <param name="upgradeResult"> Result of this upgrade. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="originalVersion"> Version before update. </param>
        /// <param name="newVersion"> Version going to update. </param>
        internal ClusterAksPatchUpgradeHistoryProperties(ClusterUpgradeHistoryType upgradeType, string utcTime, ClusterUpgradeHistoryUpgradeResultType upgradeResult, IDictionary<string, BinaryData> serializedAdditionalRawData, string originalVersion, string newVersion) : base(upgradeType, utcTime, upgradeResult, serializedAdditionalRawData)
        {
            OriginalVersion = originalVersion;
            NewVersion = newVersion;
            UpgradeType = upgradeType;
        }

        /// <summary> Initializes a new instance of <see cref="ClusterAksPatchUpgradeHistoryProperties"/> for deserialization. </summary>
        internal ClusterAksPatchUpgradeHistoryProperties()
        {
        }

        /// <summary> Version before update. </summary>
        [WirePath("originalVersion")]
        public string OriginalVersion { get; set; }
        /// <summary> Version going to update. </summary>
        [WirePath("newVersion")]
        public string NewVersion { get; set; }
    }
}
