// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> Cluster access profile. </summary>
    public partial class ClusterAccessProfile
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ClusterAccessProfile"/>. </summary>
        /// <param name="enableInternalIngress"> Whether to create cluster using private IP instead of public IP. This property must be set at create time. </param>
        public ClusterAccessProfile(bool enableInternalIngress)
        {
            EnableInternalIngress = enableInternalIngress;
        }

        /// <summary> Initializes a new instance of <see cref="ClusterAccessProfile"/>. </summary>
        /// <param name="enableInternalIngress"> Whether to create cluster using private IP instead of public IP. This property must be set at create time. </param>
        /// <param name="privateLinkServiceId"> Private link service resource ID. Only when enableInternalIngress is true, this property will be returned. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ClusterAccessProfile(bool enableInternalIngress, ResourceIdentifier privateLinkServiceId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            EnableInternalIngress = enableInternalIngress;
            PrivateLinkServiceId = privateLinkServiceId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ClusterAccessProfile"/> for deserialization. </summary>
        internal ClusterAccessProfile()
        {
        }

        /// <summary> Whether to create cluster using private IP instead of public IP. This property must be set at create time. </summary>
        [WirePath("enableInternalIngress")]
        public bool EnableInternalIngress { get; set; }
        /// <summary> Private link service resource ID. Only when enableInternalIngress is true, this property will be returned. </summary>
        [WirePath("privateLinkServiceId")]
        public ResourceIdentifier PrivateLinkServiceId { get; }
    }
}
