// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> Properties of upgrading cluster's AKS patch version. </summary>
    public partial class ClusterAKSPatchVersionUpgradeProperties : ClusterUpgradeProperties
    {
        /// <summary> Initializes a new instance of <see cref="ClusterAKSPatchVersionUpgradeProperties"/>. </summary>
        public ClusterAKSPatchVersionUpgradeProperties()
        {
            UpgradeType = ClusterUpgradeType.AKSPatchUpgrade;
        }

        /// <summary> Initializes a new instance of <see cref="ClusterAKSPatchVersionUpgradeProperties"/>. </summary>
        /// <param name="upgradeType"> Type of upgrade. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ClusterAKSPatchVersionUpgradeProperties(ClusterUpgradeType upgradeType, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(upgradeType, serializedAdditionalRawData)
        {
            UpgradeType = upgradeType;
        }
    }
}
