// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> The AutoscaleScheduleDay. </summary>
    public readonly partial struct AutoscaleScheduleDay : IEquatable<AutoscaleScheduleDay>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AutoscaleScheduleDay"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AutoscaleScheduleDay(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SundayValue = "Sunday";
        private const string MondayValue = "Monday";
        private const string TuesdayValue = "Tuesday";
        private const string WednesdayValue = "Wednesday";
        private const string ThursdayValue = "Thursday";
        private const string FridayValue = "Friday";
        private const string SaturdayValue = "Saturday";

        /// <summary> Sunday. </summary>
        public static AutoscaleScheduleDay Sunday { get; } = new AutoscaleScheduleDay(SundayValue);
        /// <summary> Monday. </summary>
        public static AutoscaleScheduleDay Monday { get; } = new AutoscaleScheduleDay(MondayValue);
        /// <summary> Tuesday. </summary>
        public static AutoscaleScheduleDay Tuesday { get; } = new AutoscaleScheduleDay(TuesdayValue);
        /// <summary> Wednesday. </summary>
        public static AutoscaleScheduleDay Wednesday { get; } = new AutoscaleScheduleDay(WednesdayValue);
        /// <summary> Thursday. </summary>
        public static AutoscaleScheduleDay Thursday { get; } = new AutoscaleScheduleDay(ThursdayValue);
        /// <summary> Friday. </summary>
        public static AutoscaleScheduleDay Friday { get; } = new AutoscaleScheduleDay(FridayValue);
        /// <summary> Saturday. </summary>
        public static AutoscaleScheduleDay Saturday { get; } = new AutoscaleScheduleDay(SaturdayValue);
        /// <summary> Determines if two <see cref="AutoscaleScheduleDay"/> values are the same. </summary>
        public static bool operator ==(AutoscaleScheduleDay left, AutoscaleScheduleDay right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AutoscaleScheduleDay"/> values are not the same. </summary>
        public static bool operator !=(AutoscaleScheduleDay left, AutoscaleScheduleDay right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AutoscaleScheduleDay"/>. </summary>
        public static implicit operator AutoscaleScheduleDay(string value) => new AutoscaleScheduleDay(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AutoscaleScheduleDay other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AutoscaleScheduleDay other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
