// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> Schedule definition. </summary>
    public partial class AutoscaleSchedule
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AutoscaleSchedule"/>. </summary>
        /// <param name="startOn"> User has to set the start time of current schedule configuration, format like 10:30 (HH:MM). </param>
        /// <param name="endOn"> User has to set the end time of current schedule configuration, format like 10:30 (HH:MM). </param>
        /// <param name="count"> User has to set the node count anticipated at end of the scaling operation of the set current schedule configuration, format is integer. </param>
        /// <param name="days"> User has to set the days where schedule has to be set for autoscale operation. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="startOn"/>, <paramref name="endOn"/> or <paramref name="days"/> is null. </exception>
        public AutoscaleSchedule(string startOn, string endOn, int count, IEnumerable<AutoscaleScheduleDay> days)
        {
            Argument.AssertNotNull(startOn, nameof(startOn));
            Argument.AssertNotNull(endOn, nameof(endOn));
            Argument.AssertNotNull(days, nameof(days));

            StartOn = startOn;
            EndOn = endOn;
            Count = count;
            Days = days.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="AutoscaleSchedule"/>. </summary>
        /// <param name="startOn"> User has to set the start time of current schedule configuration, format like 10:30 (HH:MM). </param>
        /// <param name="endOn"> User has to set the end time of current schedule configuration, format like 10:30 (HH:MM). </param>
        /// <param name="count"> User has to set the node count anticipated at end of the scaling operation of the set current schedule configuration, format is integer. </param>
        /// <param name="days"> User has to set the days where schedule has to be set for autoscale operation. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AutoscaleSchedule(string startOn, string endOn, int count, IList<AutoscaleScheduleDay> days, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            StartOn = startOn;
            EndOn = endOn;
            Count = count;
            Days = days;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="AutoscaleSchedule"/> for deserialization. </summary>
        internal AutoscaleSchedule()
        {
        }

        /// <summary> User has to set the start time of current schedule configuration, format like 10:30 (HH:MM). </summary>
        [WirePath("startTime")]
        public string StartOn { get; set; }
        /// <summary> User has to set the end time of current schedule configuration, format like 10:30 (HH:MM). </summary>
        [WirePath("endTime")]
        public string EndOn { get; set; }
        /// <summary> User has to set the node count anticipated at end of the scaling operation of the set current schedule configuration, format is integer. </summary>
        [WirePath("count")]
        public int Count { get; set; }
        /// <summary> User has to set the days where schedule has to be set for autoscale operation. </summary>
        [WirePath("days")]
        public IList<AutoscaleScheduleDay> Days { get; }
    }
}
