// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> Authorization profile with details of AAD user Ids and group Ids authorized for data plane access. </summary>
    public partial class AuthorizationProfile
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AuthorizationProfile"/>. </summary>
        public AuthorizationProfile()
        {
            UserIds = new ChangeTrackingList<string>();
            GroupIds = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="AuthorizationProfile"/>. </summary>
        /// <param name="userIds"> AAD user Ids authorized for data plane access. </param>
        /// <param name="groupIds"> AAD group Ids authorized for data plane access. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AuthorizationProfile(IList<string> userIds, IList<string> groupIds, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            UserIds = userIds;
            GroupIds = groupIds;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> AAD user Ids authorized for data plane access. </summary>
        [WirePath("userIds")]
        public IList<string> UserIds { get; }
        /// <summary> AAD group Ids authorized for data plane access. </summary>
        [WirePath("groupIds")]
        public IList<string> GroupIds { get; }
    }
}
