// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> Properties of the cluster pool underlying AKS cluster. </summary>
    public partial class AksClusterProfile
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AksClusterProfile"/>. </summary>
        internal AksClusterProfile()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AksClusterProfile"/>. </summary>
        /// <param name="aksClusterResourceId"> ARM Resource ID of the AKS cluster. </param>
        /// <param name="aksClusterAgentPoolIdentityProfile"> Identity properties of the AKS cluster agentpool MSI. </param>
        /// <param name="aksVersion"> AKS control plane and default node pool version of this ClusterPool. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AksClusterProfile(ResourceIdentifier aksClusterResourceId, HDInsightIdentityProfile aksClusterAgentPoolIdentityProfile, string aksVersion, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AksClusterResourceId = aksClusterResourceId;
            AksClusterAgentPoolIdentityProfile = aksClusterAgentPoolIdentityProfile;
            AksVersion = aksVersion;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> ARM Resource ID of the AKS cluster. </summary>
        [WirePath("aksClusterResourceId")]
        public ResourceIdentifier AksClusterResourceId { get; }
        /// <summary> Identity properties of the AKS cluster agentpool MSI. </summary>
        [WirePath("aksClusterAgentPoolIdentityProfile")]
        public HDInsightIdentityProfile AksClusterAgentPoolIdentityProfile { get; }
        /// <summary> AKS control plane and default node pool version of this ClusterPool. </summary>
        [WirePath("aksVersion")]
        public string AksVersion { get; }
    }
}
