// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.HDInsight.Containers
{
    internal class HDInsightClusterPoolOperationSource : IOperationSource<HDInsightClusterPoolResource>
    {
        private readonly ArmClient _client;

        internal HDInsightClusterPoolOperationSource(ArmClient client)
        {
            _client = client;
        }

        HDInsightClusterPoolResource IOperationSource<HDInsightClusterPoolResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = HDInsightClusterPoolData.DeserializeHDInsightClusterPoolData(document.RootElement);
            return new HDInsightClusterPoolResource(_client, data);
        }

        async ValueTask<HDInsightClusterPoolResource> IOperationSource<HDInsightClusterPoolResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = HDInsightClusterPoolData.DeserializeHDInsightClusterPoolData(document.RootElement);
            return new HDInsightClusterPoolResource(_client, data);
        }
    }
}
