// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.HDInsight.Containers
{
    internal class HDInsightClusterOperationSource : IOperationSource<HDInsightClusterResource>
    {
        private readonly ArmClient _client;

        internal HDInsightClusterOperationSource(ArmClient client)
        {
            _client = client;
        }

        HDInsightClusterResource IOperationSource<HDInsightClusterResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = HDInsightClusterData.DeserializeHDInsightClusterData(document.RootElement);
            return new HDInsightClusterResource(_client, data);
        }

        async ValueTask<HDInsightClusterResource> IOperationSource<HDInsightClusterResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = HDInsightClusterData.DeserializeHDInsightClusterData(document.RootElement);
            return new HDInsightClusterResource(_client, data);
        }
    }
}
