// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.ResourceManager.HDInsight.Containers.Models;

namespace Azure.ResourceManager.HDInsight.Containers
{
    internal class ClusterJobOperationSource : IOperationSource<ClusterJob>
    {
        ClusterJob IOperationSource<ClusterJob>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            return ClusterJob.DeserializeClusterJob(document.RootElement);
        }

        async ValueTask<ClusterJob> IOperationSource<ClusterJob>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            return ClusterJob.DeserializeClusterJob(document.RootElement);
        }
    }
}
