// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmHDInsightContainersModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="Containers.HDInsightClusterPoolData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="properties"> Gets or sets the properties. Define cluster pool specific properties. </param>
        /// <returns> A new <see cref="Containers.HDInsightClusterPoolData"/> instance for mocking. </returns>
        public static HDInsightClusterPoolData HDInsightClusterPoolData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, HDInsightClusterPoolProperties properties = null)
        {
            tags ??= new Dictionary<string, string>();

            return new HDInsightClusterPoolData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HDInsightClusterPoolProperties"/>. </summary>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <param name="deploymentId"> A unique id generated by the RP to identify the resource. </param>
        /// <param name="managedResourceGroupName"> A resource group created by RP, to hold the resources created by RP on-behalf of customers. It will also be used to generate aksManagedResourceGroupName by pattern: MC_{managedResourceGroupName}_{clusterPoolName}_{region}. Please make sure it meets resource group name restriction. </param>
        /// <param name="aksManagedResourceGroupName"> A resource group created by AKS, to hold the infrastructure resources created by AKS on-behalf of customers. It is generated by cluster pool name and managed resource group name by pattern: MC_{managedResourceGroupName}_{clusterPoolName}_{region}. </param>
        /// <param name="clusterPoolVersion"> CLuster pool profile. </param>
        /// <param name="computeProfile"> CLuster pool compute profile. </param>
        /// <param name="aksClusterProfile"> Properties of underlying AKS cluster. </param>
        /// <param name="networkProfile"> Cluster pool network profile. </param>
        /// <param name="logAnalyticsProfile"> Cluster pool log analytics profile to enable OMS agent for AKS cluster. </param>
        /// <param name="status"> Business status of the resource. </param>
        /// <returns> A new <see cref="Models.HDInsightClusterPoolProperties"/> instance for mocking. </returns>
        public static HDInsightClusterPoolProperties HDInsightClusterPoolProperties(HDInsightProvisioningStatus? provisioningState = null, string deploymentId = null, string managedResourceGroupName = null, string aksManagedResourceGroupName = null, string clusterPoolVersion = null, ClusterPoolComputeProfile computeProfile = null, AksClusterProfile aksClusterProfile = null, ClusterPoolNetworkProfile networkProfile = null, ClusterPoolLogAnalyticsProfile logAnalyticsProfile = null, string status = null)
        {
            return new HDInsightClusterPoolProperties(
                provisioningState,
                deploymentId,
                managedResourceGroupName,
                aksManagedResourceGroupName,
                clusterPoolVersion != null ? new ClusterPoolProfile(clusterPoolVersion, serializedAdditionalRawData: null) : null,
                computeProfile,
                aksClusterProfile,
                networkProfile,
                logAnalyticsProfile,
                status,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ClusterPoolComputeProfile"/>. </summary>
        /// <param name="vmSize"> The virtual machine SKU. </param>
        /// <param name="count"> The number of virtual machines. </param>
        /// <param name="availabilityZones"> The list of Availability zones to use for AKS VMSS nodes. </param>
        /// <returns> A new <see cref="Models.ClusterPoolComputeProfile"/> instance for mocking. </returns>
        public static ClusterPoolComputeProfile ClusterPoolComputeProfile(string vmSize = null, int? count = null, IEnumerable<string> availabilityZones = null)
        {
            availabilityZones ??= new List<string>();

            return new ClusterPoolComputeProfile(vmSize, count, availabilityZones?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AksClusterProfile"/>. </summary>
        /// <param name="aksClusterResourceId"> ARM Resource ID of the AKS cluster. </param>
        /// <param name="aksClusterAgentPoolIdentityProfile"> Identity properties of the AKS cluster agentpool MSI. </param>
        /// <param name="aksVersion"> AKS control plane and default node pool version of this ClusterPool. </param>
        /// <returns> A new <see cref="Models.AksClusterProfile"/> instance for mocking. </returns>
        public static AksClusterProfile AksClusterProfile(ResourceIdentifier aksClusterResourceId = null, HDInsightIdentityProfile aksClusterAgentPoolIdentityProfile = null, string aksVersion = null)
        {
            return new AksClusterProfile(aksClusterResourceId, aksClusterAgentPoolIdentityProfile, aksVersion, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ClusterPoolAvailableUpgrade"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties">
        /// Gets or sets the properties. Define cluster pool upgrade specific properties.
        /// Please note <see cref="ClusterPoolAvailableUpgradeProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ClusterPoolAvailableUpgradeAksPatchUpgradeProperties"/> and <see cref="ClusterPoolAvailableUpgradeNodeOSUpgradeProperties"/>.
        /// </param>
        /// <returns> A new <see cref="Models.ClusterPoolAvailableUpgrade"/> instance for mocking. </returns>
        public static ClusterPoolAvailableUpgrade ClusterPoolAvailableUpgrade(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ClusterPoolAvailableUpgradeProperties properties = null)
        {
            return new ClusterPoolAvailableUpgrade(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ClusterPoolUpgradeHistory"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties">
        /// Properties of cluster pool upgrade history.
        /// Please note <see cref="ClusterPoolUpgradeHistoryProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ClusterPoolAksPatchUpgradeHistoryProperties"/> and <see cref="ClusterPoolNodeOSUpgradeHistoryProperties"/>.
        /// </param>
        /// <returns> A new <see cref="Models.ClusterPoolUpgradeHistory"/> instance for mocking. </returns>
        public static ClusterPoolUpgradeHistory ClusterPoolUpgradeHistory(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ClusterPoolUpgradeHistoryProperties properties = null)
        {
            return new ClusterPoolUpgradeHistory(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Containers.HDInsightClusterData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="properties"> Gets or sets the properties. Define cluster specific properties. </param>
        /// <returns> A new <see cref="Containers.HDInsightClusterData"/> instance for mocking. </returns>
        public static HDInsightClusterData HDInsightClusterData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, HDInsightClusterProperties properties = null)
        {
            tags ??= new Dictionary<string, string>();

            return new HDInsightClusterData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HDInsightClusterProperties"/>. </summary>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <param name="clusterType"> The type of cluster. </param>
        /// <param name="deploymentId"> A unique id generated by the RP to identify the resource. </param>
        /// <param name="computeProfile"> The compute profile. </param>
        /// <param name="clusterProfile"> Cluster profile. </param>
        /// <param name="status"> Business status of the resource. </param>
        /// <returns> A new <see cref="Models.HDInsightClusterProperties"/> instance for mocking. </returns>
        public static HDInsightClusterProperties HDInsightClusterProperties(HDInsightProvisioningStatus? provisioningState = null, string clusterType = null, string deploymentId = null, ClusterComputeProfile computeProfile = null, ClusterProfile clusterProfile = null, string status = null)
        {
            return new HDInsightClusterProperties(
                provisioningState,
                clusterType,
                deploymentId,
                computeProfile,
                clusterProfile,
                status,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ClusterProfile"/>. </summary>
        /// <param name="clusterVersion"> Version with 3/4 part. </param>
        /// <param name="ossVersion"> Version with three part. </param>
        /// <param name="components"> Component list of this cluster type and version. </param>
        /// <param name="identityProfile"> This is deprecated. Please use managed identity profile instead. </param>
        /// <param name="identityList"> This property is required by Trino, Spark and Flink cluster but is optional for Kafka cluster. </param>
        /// <param name="authorizationProfile"> Authorization profile with details of AAD user Ids and group Ids authorized for data plane access. </param>
        /// <param name="secretsProfile"> The cluster secret profile. </param>
        /// <param name="serviceConfigsProfiles"> The service configs profiles. </param>
        /// <param name="connectivityProfile"> Cluster connectivity profile. </param>
        /// <param name="clusterAccessProfile"> Cluster access profile. </param>
        /// <param name="logAnalyticsProfile"> Cluster log analytics profile to enable or disable OMS agent for cluster. </param>
        /// <param name="isEnabled"> Cluster Prometheus profile. </param>
        /// <param name="sshProfile"> Ssh profile for the cluster. </param>
        /// <param name="autoscaleProfile"> This is the Autoscale profile for the cluster. This will allow customer to create cluster enabled with Autoscale. </param>
        /// <param name="isRangerForClusterEnabled"> Cluster Ranger plugin profile. </param>
        /// <param name="kafkaProfile"> The Kafka cluster profile. </param>
        /// <param name="trinoProfile"> Trino Cluster profile. </param>
        /// <param name="llapProfile"> LLAP cluster profile. </param>
        /// <param name="flinkProfile"> The Flink cluster profile. </param>
        /// <param name="sparkProfile"> The spark cluster profile. </param>
        /// <param name="rangerProfile"> The ranger cluster profile. </param>
        /// <param name="stubProfile"> Stub cluster profile. </param>
        /// <param name="scriptActionProfiles"> The script action profile list. </param>
        /// <returns> A new <see cref="Models.ClusterProfile"/> instance for mocking. </returns>
        public static ClusterProfile ClusterProfile(string clusterVersion = null, string ossVersion = null, IEnumerable<ClusterComponentItem> components = null, HDInsightIdentityProfile identityProfile = null, IEnumerable<HDInsightManagedIdentitySpec> identityList = null, AuthorizationProfile authorizationProfile = null, ClusterSecretsProfile secretsProfile = null, IEnumerable<ClusterServiceConfigsProfile> serviceConfigsProfiles = null, ClusterConnectivityProfile connectivityProfile = null, ClusterAccessProfile clusterAccessProfile = null, ClusterLogAnalyticsProfile logAnalyticsProfile = null, bool? isEnabled = null, ClusterSshProfile sshProfile = null, ClusterAutoscaleProfile autoscaleProfile = null, bool? isRangerForClusterEnabled = null, KafkaProfile kafkaProfile = null, TrinoProfile trinoProfile = null, IDictionary<string, BinaryData> llapProfile = null, FlinkProfile flinkProfile = null, SparkProfile sparkProfile = null, RangerProfile rangerProfile = null, IDictionary<string, BinaryData> stubProfile = null, IEnumerable<ScriptActionProfile> scriptActionProfiles = null)
        {
            components ??= new List<ClusterComponentItem>();
            identityList ??= new List<HDInsightManagedIdentitySpec>();
            serviceConfigsProfiles ??= new List<ClusterServiceConfigsProfile>();
            llapProfile ??= new Dictionary<string, BinaryData>();
            stubProfile ??= new Dictionary<string, BinaryData>();
            scriptActionProfiles ??= new List<ScriptActionProfile>();

            return new ClusterProfile(
                clusterVersion,
                ossVersion,
                components?.ToList(),
                identityProfile,
                identityList != null ? new ManagedIdentityProfile(identityList?.ToList(), serializedAdditionalRawData: null) : null,
                authorizationProfile,
                secretsProfile,
                serviceConfigsProfiles?.ToList(),
                connectivityProfile,
                clusterAccessProfile,
                logAnalyticsProfile,
                isEnabled.HasValue ? new ClusterPrometheusProfile(isEnabled.Value, serializedAdditionalRawData: null) : null,
                sshProfile,
                autoscaleProfile,
                isRangerForClusterEnabled.HasValue ? new ClusterRangerPluginProfile(isRangerForClusterEnabled.Value, serializedAdditionalRawData: null) : null,
                kafkaProfile,
                trinoProfile,
                llapProfile,
                flinkProfile,
                sparkProfile,
                rangerProfile,
                stubProfile,
                scriptActionProfiles?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ClusterComponentItem"/>. </summary>
        /// <param name="name"></param>
        /// <param name="version"></param>
        /// <returns> A new <see cref="Models.ClusterComponentItem"/> instance for mocking. </returns>
        public static ClusterComponentItem ClusterComponentItem(string name = null, string version = null)
        {
            return new ClusterComponentItem(name, version, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ClusterConnectivityProfile"/>. </summary>
        /// <param name="web"> Web connectivity endpoint details. </param>
        /// <param name="ssh"> List of SSH connectivity endpoints. </param>
        /// <returns> A new <see cref="Models.ClusterConnectivityProfile"/> instance for mocking. </returns>
        public static ClusterConnectivityProfile ClusterConnectivityProfile(WebConnectivityEndpoint web = null, IEnumerable<SshConnectivityEndpoint> ssh = null)
        {
            ssh ??= new List<SshConnectivityEndpoint>();

            return new ClusterConnectivityProfile(web, ssh?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.WebConnectivityEndpoint"/>. </summary>
        /// <param name="fqdn"> Web connectivity endpoint. </param>
        /// <param name="privateFqdn"> Private web connectivity endpoint. This property will only be returned when enableInternalIngress is true. </param>
        /// <returns> A new <see cref="Models.WebConnectivityEndpoint"/> instance for mocking. </returns>
        public static WebConnectivityEndpoint WebConnectivityEndpoint(string fqdn = null, string privateFqdn = null)
        {
            return new WebConnectivityEndpoint(fqdn, privateFqdn, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SshConnectivityEndpoint"/>. </summary>
        /// <param name="endpoint"> SSH connectivity endpoint. </param>
        /// <param name="privateSshEndpoint"> Private SSH connectivity endpoint. This property will only be returned when enableInternalIngress is true. </param>
        /// <returns> A new <see cref="Models.SshConnectivityEndpoint"/> instance for mocking. </returns>
        public static SshConnectivityEndpoint SshConnectivityEndpoint(string endpoint = null, string privateSshEndpoint = null)
        {
            return new SshConnectivityEndpoint(endpoint, privateSshEndpoint, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ClusterAccessProfile"/>. </summary>
        /// <param name="enableInternalIngress"> Whether to create cluster using private IP instead of public IP. This property must be set at create time. </param>
        /// <param name="privateLinkServiceId"> Private link service resource ID. Only when enableInternalIngress is true, this property will be returned. </param>
        /// <returns> A new <see cref="Models.ClusterAccessProfile"/> instance for mocking. </returns>
        public static ClusterAccessProfile ClusterAccessProfile(bool enableInternalIngress = default, ResourceIdentifier privateLinkServiceId = null)
        {
            return new ClusterAccessProfile(enableInternalIngress, privateLinkServiceId, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ClusterSshProfile"/>. </summary>
        /// <param name="count"> Number of ssh pods per cluster. </param>
        /// <param name="podPrefix"> Prefix of the pod names. Pod number will be appended to the prefix. The ingress URLs for the pods will be available at &lt;clusterFqdn&gt;/&lt;sshBasePath&gt;/&lt;prefix&gt;-&lt;number&gt;. </param>
        /// <param name="vmSize"> The virtual machine SKU. </param>
        /// <returns> A new <see cref="Models.ClusterSshProfile"/> instance for mocking. </returns>
        public static ClusterSshProfile ClusterSshProfile(int count = default, string podPrefix = null, string vmSize = null)
        {
            return new ClusterSshProfile(count, podPrefix, vmSize, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.KafkaProfile"/>. </summary>
        /// <param name="isKRaftEnabled"> Expose Kafka cluster in KRaft mode. </param>
        /// <param name="isPublicEndpointsEnabled"> Expose worker nodes as public endpoints. </param>
        /// <param name="remoteStorageUriString"> Fully qualified path of Azure Storage container used for Tiered Storage. </param>
        /// <param name="diskStorage"> Kafka disk storage profile. </param>
        /// <param name="connectivityEndpoints"> Kafka bootstrap server and brokers related connectivity endpoints. </param>
        /// <returns> A new <see cref="Models.KafkaProfile"/> instance for mocking. </returns>
        public static KafkaProfile KafkaProfile(bool? isKRaftEnabled = null, bool? isPublicEndpointsEnabled = null, string remoteStorageUriString = null, DiskStorageProfile diskStorage = null, KafkaConnectivityEndpoints connectivityEndpoints = null)
        {
            return new KafkaProfile(
                isKRaftEnabled,
                isPublicEndpointsEnabled,
                remoteStorageUriString,
                diskStorage,
                connectivityEndpoints,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.KafkaConnectivityEndpoints"/>. </summary>
        /// <param name="bootstrapServerEndpoint"> bootstrap server connectivity endpoint. </param>
        /// <param name="brokerEndpoints"> Kafka broker endpoint list. </param>
        /// <returns> A new <see cref="Models.KafkaConnectivityEndpoints"/> instance for mocking. </returns>
        public static KafkaConnectivityEndpoints KafkaConnectivityEndpoints(string bootstrapServerEndpoint = null, IEnumerable<string> brokerEndpoints = null)
        {
            brokerEndpoints ??= new List<string>();

            return new KafkaConnectivityEndpoints(bootstrapServerEndpoint, brokerEndpoints?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ClusterAvailableUpgrade"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties">
        /// Gets or sets the properties. Define cluster upgrade specific properties.
        /// Please note <see cref="ClusterAvailableUpgradeProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ClusterAvailableUpgradeAksPatchUpgradeProperties"/>, <see cref="ClusterAvailableInPlaceUpgradeProperties"/>, <see cref="ClusterAvailableUpgradeHotfixUpgradeProperties"/> and <see cref="ClusterAvailableUpgradePatchVersionUpgradeProperties"/>.
        /// </param>
        /// <returns> A new <see cref="Models.ClusterAvailableUpgrade"/> instance for mocking. </returns>
        public static ClusterAvailableUpgrade ClusterAvailableUpgrade(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ClusterAvailableUpgradeProperties properties = null)
        {
            return new ClusterAvailableUpgrade(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ClusterUpgradeHistory"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties">
        /// Properties of cluster upgrade history.
        /// Please note <see cref="ClusterUpgradeHistoryProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ClusterAksPatchUpgradeHistoryProperties"/>, <see cref="ClusterInPlaceUpgradeHistoryProperties"/>, <see cref="ClusterHotfixUpgradeHistoryProperties"/>, <see cref="ClusterHotfixUpgradeRollbackHistoryProperties"/>, <see cref="ClusterPatchVersionUpgradeHistoryProperties"/> and <see cref="ClusterPatchVersionUpgradeRollbackHistoryProperties"/>.
        /// </param>
        /// <returns> A new <see cref="Models.ClusterUpgradeHistory"/> instance for mocking. </returns>
        public static ClusterUpgradeHistory ClusterUpgradeHistory(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ClusterUpgradeHistoryProperties properties = null)
        {
            return new ClusterUpgradeHistory(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ClusterResizeContent"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="clusterResizeTargetWorkerNodeCount"> Sets the properties. Define cluster resize specific properties. </param>
        /// <returns> A new <see cref="Models.ClusterResizeContent"/> instance for mocking. </returns>
        public static ClusterResizeContent ClusterResizeContent(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, int? clusterResizeTargetWorkerNodeCount = null)
        {
            tags ??= new Dictionary<string, string>();

            return new ClusterResizeContent(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                clusterResizeTargetWorkerNodeCount.HasValue ? new ClusterResizeProperties(clusterResizeTargetWorkerNodeCount.Value, serializedAdditionalRawData: null) : null,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ClusterJob"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties">
        /// Properties of cluster job.
        /// Please note <see cref="ClusterJobProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.FlinkJobProperties"/>.
        /// </param>
        /// <returns> A new <see cref="Models.ClusterJob"/> instance for mocking. </returns>
        public static ClusterJob ClusterJob(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ClusterJobProperties properties = null)
        {
            return new ClusterJob(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ClusterServiceConfigResult"/>. </summary>
        /// <param name="properties"> Cluster instance service config properties. </param>
        /// <returns> A new <see cref="Models.ClusterServiceConfigResult"/> instance for mocking. </returns>
        public static ClusterServiceConfigResult ClusterServiceConfigResult(ClusterServiceConfigProperties properties = null)
        {
            return new ClusterServiceConfigResult(properties, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ClusterServiceConfigProperties"/>. </summary>
        /// <param name="serviceName"> Service Config Name. </param>
        /// <param name="fileName"> File Name. </param>
        /// <param name="content"> Content in the service config file. </param>
        /// <param name="componentName"> Component Name. </param>
        /// <param name="serviceConfigListResultPropertiesType"> Config type. </param>
        /// <param name="path"> Config file path. </param>
        /// <param name="customKeys"> The custom keys. </param>
        /// <param name="defaultKeys"> The default keys. </param>
        /// <returns> A new <see cref="Models.ClusterServiceConfigProperties"/> instance for mocking. </returns>
        public static ClusterServiceConfigProperties ClusterServiceConfigProperties(string serviceName = null, string fileName = null, string content = null, string componentName = null, string serviceConfigListResultPropertiesType = null, string path = null, IReadOnlyDictionary<string, string> customKeys = null, IReadOnlyDictionary<string, ClusterServiceConfigValueEntity> defaultKeys = null)
        {
            customKeys ??= new Dictionary<string, string>();
            defaultKeys ??= new Dictionary<string, ClusterServiceConfigValueEntity>();

            return new ClusterServiceConfigProperties(
                serviceName,
                fileName,
                content,
                componentName,
                serviceConfigListResultPropertiesType,
                path,
                customKeys,
                defaultKeys,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ClusterServiceConfigValueEntity"/>. </summary>
        /// <param name="value"> Config value. </param>
        /// <param name="description"> Config description. </param>
        /// <returns> A new <see cref="Models.ClusterServiceConfigValueEntity"/> instance for mocking. </returns>
        public static ClusterServiceConfigValueEntity ClusterServiceConfigValueEntity(string value = null, string description = null)
        {
            return new ClusterServiceConfigValueEntity(value, description, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HDInsightNameAvailabilityResult"/>. </summary>
        /// <param name="isNameAvailable"> Indicator of availability of the Microsoft.HDInsight resource name. </param>
        /// <param name="reason"> The reason of unavailability. </param>
        /// <param name="message"> The error message of unavailability. </param>
        /// <returns> A new <see cref="Models.HDInsightNameAvailabilityResult"/> instance for mocking. </returns>
        public static HDInsightNameAvailabilityResult HDInsightNameAvailabilityResult(bool? isNameAvailable = null, string reason = null, string message = null)
        {
            return new HDInsightNameAvailabilityResult(isNameAvailable, reason, message, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ClusterInstanceViewResult"/>. </summary>
        /// <param name="name"> Name of the instance view. </param>
        /// <param name="properties"> Properties of the instance view. </param>
        /// <returns> A new <see cref="Models.ClusterInstanceViewResult"/> instance for mocking. </returns>
        public static ClusterInstanceViewResult ClusterInstanceViewResult(string name = null, ClusterInstanceViewProperties properties = null)
        {
            return new ClusterInstanceViewResult(name, properties, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ClusterInstanceViewProperties"/>. </summary>
        /// <param name="status"> Status of the instance view. </param>
        /// <param name="serviceStatuses"> List of statuses of relevant services that make up the HDInsight on AKS cluster to surface to the customer. </param>
        /// <returns> A new <see cref="Models.ClusterInstanceViewProperties"/> instance for mocking. </returns>
        public static ClusterInstanceViewProperties ClusterInstanceViewProperties(ClusterInstanceViewStatus status = null, IEnumerable<HDInsightServiceStatus> serviceStatuses = null)
        {
            serviceStatuses ??= new List<HDInsightServiceStatus>();

            return new ClusterInstanceViewProperties(status, serviceStatuses?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ClusterInstanceViewStatus"/>. </summary>
        /// <param name="ready"> The cluster ready status. </param>
        /// <param name="reason"> The status reason. </param>
        /// <param name="message"> The additional message. </param>
        /// <returns> A new <see cref="Models.ClusterInstanceViewStatus"/> instance for mocking. </returns>
        public static ClusterInstanceViewStatus ClusterInstanceViewStatus(string ready = null, string reason = null, string message = null)
        {
            return new ClusterInstanceViewStatus(ready, reason, message, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HDInsightServiceStatus"/>. </summary>
        /// <param name="kind"> Kind of the service. E.g. "Zookeeper". </param>
        /// <param name="ready"> Indicates if the service is ready / healthy. Values can be "true", "false", "unknown" or anything else. </param>
        /// <param name="message"> A message describing the error if any. </param>
        /// <returns> A new <see cref="Models.HDInsightServiceStatus"/> instance for mocking. </returns>
        public static HDInsightServiceStatus HDInsightServiceStatus(string kind = null, string ready = null, string message = null)
        {
            return new HDInsightServiceStatus(kind, ready, message, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ClusterPoolVersion"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Cluster pool version properties. </param>
        /// <returns> A new <see cref="Models.ClusterPoolVersion"/> instance for mocking. </returns>
        public static ClusterPoolVersion ClusterPoolVersion(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ClusterPoolVersionProperties properties = null)
        {
            return new ClusterPoolVersion(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HDInsightClusterVersion"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Cluster version properties. </param>
        /// <returns> A new <see cref="Models.HDInsightClusterVersion"/> instance for mocking. </returns>
        public static HDInsightClusterVersion HDInsightClusterVersion(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ClusterVersionProperties properties = null)
        {
            return new HDInsightClusterVersion(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ClusterVersionProperties"/>. </summary>
        /// <param name="clusterType"> The type of cluster. </param>
        /// <param name="clusterVersion"> Version with three part. </param>
        /// <param name="ossVersion"> Version with three part. </param>
        /// <param name="clusterPoolVersion"> The two part cluster pool version. If the cluster version is before cluster pool version on-board, the return value will be empty string. </param>
        /// <param name="isPreview"> Indicate if this version is in preview or not. </param>
        /// <param name="components"> Component list of this cluster type and version. </param>
        /// <returns> A new <see cref="Models.ClusterVersionProperties"/> instance for mocking. </returns>
        public static ClusterVersionProperties ClusterVersionProperties(string clusterType = null, string clusterVersion = null, string ossVersion = null, string clusterPoolVersion = null, bool? isPreview = null, IEnumerable<ClusterComponentItem> components = null)
        {
            components ??= new List<ClusterComponentItem>();

            return new ClusterVersionProperties(
                clusterType,
                clusterVersion,
                ossVersion,
                clusterPoolVersion,
                isPreview,
                components?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ClusterLibrary"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties">
        /// Properties of a library in the cluster.
        /// Please note <see cref="Models.ClusterLibraryProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.ClusterMavenLibraryProperties"/> and <see cref="Models.ClusterPyPILibraryProperties"/>.
        /// </param>
        /// <returns> A new <see cref="Models.ClusterLibrary"/> instance for mocking. </returns>
        public static ClusterLibrary ClusterLibrary(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ClusterLibraryProperties properties = null)
        {
            return new ClusterLibrary(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ClusterLibraryProperties"/>. </summary>
        /// <param name="libraryType"> Type of the library. </param>
        /// <param name="remarks"> Remark of the latest library management operation. </param>
        /// <param name="timestamp"> Timestamp of the latest library management operation. </param>
        /// <param name="status"> Status of the library. </param>
        /// <param name="message"> Error message of the library operation when a failure occurs. </param>
        /// <returns> A new <see cref="Models.ClusterLibraryProperties"/> instance for mocking. </returns>
        public static ClusterLibraryProperties ClusterLibraryProperties(string libraryType = null, string remarks = null, DateTimeOffset? timestamp = null, Status? status = null, string message = null)
        {
            return new UnknownClusterLibraryProperties(
                libraryType == null ? default : new Type(libraryType),
                remarks,
                timestamp,
                status,
                message,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ClusterLibraryManagementOperationContent"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Properties of a library management operation. </param>
        /// <returns> A new <see cref="Models.ClusterLibraryManagementOperationContent"/> instance for mocking. </returns>
        public static ClusterLibraryManagementOperationContent ClusterLibraryManagementOperationContent(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ClusterLibraryManagementOperationProperties properties = null)
        {
            return new ClusterLibraryManagementOperationContent(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.FlinkJobProperties"/>. </summary>
        /// <param name="runId"> Run id of job. </param>
        /// <param name="jobName"> Name of job. </param>
        /// <param name="jobJarDirectory"> A string property that specifies the directory where the job JAR is located. </param>
        /// <param name="jarName"> A string property that represents the name of the job JAR. </param>
        /// <param name="entryClass"> A string property that specifies the entry class for the Flink job. </param>
        /// <param name="args"> A string property representing additional JVM arguments for the Flink job. It should be space separated value. </param>
        /// <param name="savePointName"> A string property that represents the name of the savepoint for the Flink job. </param>
        /// <param name="action"> A string property that indicates the action to be performed on the Flink job. It can have one of the following enum values =&gt; NEW, UPDATE, STATELESS_UPDATE, STOP, START, CANCEL, SAVEPOINT, LIST_SAVEPOINT, or DELETE. </param>
        /// <param name="flinkConfiguration"> Additional properties used to configure Flink jobs. It allows users to set properties such as parallelism and jobSavePointDirectory. It accepts additional key-value pairs as properties, where the keys are strings and the values are strings as well. </param>
        /// <param name="jobId"> Unique id for identifying a job. </param>
        /// <param name="status"> Status of job. </param>
        /// <param name="jobOutput"> Output of job. </param>
        /// <param name="actionResult"> Action result of job. </param>
        /// <param name="lastSavePoint"> The last savepoint. </param>
        /// <returns> A new <see cref="Models.FlinkJobProperties"/> instance for mocking. </returns>
        public static FlinkJobProperties FlinkJobProperties(string runId = null, string jobName = null, string jobJarDirectory = null, string jarName = null, string entryClass = null, string args = null, string savePointName = null, FlinkJobAction? action = null, IDictionary<string, string> flinkConfiguration = null, string jobId = null, string status = null, string jobOutput = null, string actionResult = null, string lastSavePoint = null)
        {
            flinkConfiguration ??= new Dictionary<string, string>();

            return new FlinkJobProperties(
                ClusterJobType.FlinkJob,
                serializedAdditionalRawData: null,
                runId,
                jobName,
                jobJarDirectory,
                jarName,
                entryClass,
                args,
                savePointName,
                action,
                flinkConfiguration,
                jobId,
                status,
                jobOutput,
                actionResult,
                lastSavePoint);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ClusterPyPILibraryProperties"/>. </summary>
        /// <param name="remarks"> Remark of the latest library management operation. </param>
        /// <param name="timestamp"> Timestamp of the latest library management operation. </param>
        /// <param name="status"> Status of the library. </param>
        /// <param name="message"> Error message of the library operation when a failure occurs. </param>
        /// <param name="name"> Name of the PyPi package. </param>
        /// <param name="version"> Version of the PyPi package. </param>
        /// <returns> A new <see cref="Models.ClusterPyPILibraryProperties"/> instance for mocking. </returns>
        public static ClusterPyPILibraryProperties ClusterPyPILibraryProperties(string remarks = null, DateTimeOffset? timestamp = null, Status? status = null, string message = null, string name = null, string version = null)
        {
            return new ClusterPyPILibraryProperties(
                Type.Pypi,
                remarks,
                timestamp,
                status,
                message,
                serializedAdditionalRawData: null,
                name,
                version);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ClusterMavenLibraryProperties"/>. </summary>
        /// <param name="remarks"> Remark of the latest library management operation. </param>
        /// <param name="timestamp"> Timestamp of the latest library management operation. </param>
        /// <param name="status"> Status of the library. </param>
        /// <param name="message"> Error message of the library operation when a failure occurs. </param>
        /// <param name="groupId"> GroupId of the Maven package. </param>
        /// <param name="name"> ArtifactId of the Maven package. </param>
        /// <param name="version"> Version of the Maven package. </param>
        /// <returns> A new <see cref="Models.ClusterMavenLibraryProperties"/> instance for mocking. </returns>
        public static ClusterMavenLibraryProperties ClusterMavenLibraryProperties(string remarks = null, DateTimeOffset? timestamp = null, Status? status = null, string message = null, string groupId = null, string name = null, string version = null)
        {
            return new ClusterMavenLibraryProperties(
                Type.Maven,
                remarks,
                timestamp,
                status,
                message,
                serializedAdditionalRawData: null,
                groupId,
                name,
                version);
        }
    }
}
