// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.HDInsight.Containers.Models;

namespace Azure.ResourceManager.HDInsight.Containers.Samples
{
    public partial class Sample_HDInsightClusterResource
    {
        // ClustersUpgradeAKSPatchVersion
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Upgrade_ClustersUpgradeAKSPatchVersion()
        {
            // Generated from example definition: specification/hdinsight/resource-manager/Microsoft.HDInsight/HDInsightOnAks/preview/2024-05-01-preview/examples/UpgradeAKSPatchVersionForCluster.json
            // this example is just showing the usage of "Clusters_Upgrade" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this HDInsightClusterResource created on azure
            // for more information of creating HDInsightClusterResource, please refer to the document of HDInsightClusterResource
            string subscriptionId = "10e32bab-26da-4cc4-a441-52b318f824e6";
            string resourceGroupName = "hiloResourcegroup";
            string clusterPoolName = "clusterpool1";
            string clusterName = "cluster1";
            ResourceIdentifier hdInsightClusterResourceId = HDInsightClusterResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, clusterPoolName, clusterName);
            HDInsightClusterResource hdInsightCluster = client.GetHDInsightClusterResource(hdInsightClusterResourceId);

            // invoke the operation
            ClusterUpgrade clusterUpgradeRequest = new ClusterUpgrade(new ClusterAKSPatchVersionUpgradeProperties());
            ArmOperation<HDInsightClusterResource> lro = await hdInsightCluster.UpgradeAsync(WaitUntil.Completed, clusterUpgradeRequest);
            HDInsightClusterResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            HDInsightClusterData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ClustersUpgradeHotfix
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Upgrade_ClustersUpgradeHotfix()
        {
            // Generated from example definition: specification/hdinsight/resource-manager/Microsoft.HDInsight/HDInsightOnAks/preview/2024-05-01-preview/examples/UpgradeHotfixForCluster.json
            // this example is just showing the usage of "Clusters_Upgrade" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this HDInsightClusterResource created on azure
            // for more information of creating HDInsightClusterResource, please refer to the document of HDInsightClusterResource
            string subscriptionId = "10e32bab-26da-4cc4-a441-52b318f824e6";
            string resourceGroupName = "hiloResourcegroup";
            string clusterPoolName = "clusterpool1";
            string clusterName = "cluster1";
            ResourceIdentifier hdInsightClusterResourceId = HDInsightClusterResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, clusterPoolName, clusterName);
            HDInsightClusterResource hdInsightCluster = client.GetHDInsightClusterResource(hdInsightClusterResourceId);

            // invoke the operation
            ClusterUpgrade clusterUpgradeRequest = new ClusterUpgrade(new ClusterHotfixUpgradeProperties()
            {
                TargetOssVersion = "1.16.0",
                TargetClusterVersion = "1.0.6",
                TargetBuildNumber = "3",
                ComponentName = "historyserver",
            });
            ArmOperation<HDInsightClusterResource> lro = await hdInsightCluster.UpgradeAsync(WaitUntil.Completed, clusterUpgradeRequest);
            HDInsightClusterResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            HDInsightClusterData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ClusterUpgradeRollback
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task UpgradeManualRollback_ClusterUpgradeRollback()
        {
            // Generated from example definition: specification/hdinsight/resource-manager/Microsoft.HDInsight/HDInsightOnAks/preview/2024-05-01-preview/examples/ClusterUpgradeRollback.json
            // this example is just showing the usage of "Clusters_UpgradeManualRollback" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this HDInsightClusterResource created on azure
            // for more information of creating HDInsightClusterResource, please refer to the document of HDInsightClusterResource
            string subscriptionId = "10e32bab-26da-4cc4-a441-52b318f824e6";
            string resourceGroupName = "hiloResourcegroup";
            string clusterPoolName = "clusterpool1";
            string clusterName = "cluster1";
            ResourceIdentifier hdInsightClusterResourceId = HDInsightClusterResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, clusterPoolName, clusterName);
            HDInsightClusterResource hdInsightCluster = client.GetHDInsightClusterResource(hdInsightClusterResourceId);

            // invoke the operation
            ClusterUpgradeRollback clusterRollbackUpgradeRequest = new ClusterUpgradeRollback(new ClusterUpgradeRollbackProperties("/subscriptions/10e32bab-26da-4cc4-a441-52b318f824e6/resourceGroups/hiloResourcegroup/providers/Microsoft.HDInsight/clusterpools/clusterpool1/clusters/cluster1/upgradeHistories/01_11_2024_02_35_03_AM-HotfixUpgrade"));
            ArmOperation<HDInsightClusterResource> lro = await hdInsightCluster.UpgradeManualRollbackAsync(WaitUntil.Completed, clusterRollbackUpgradeRequest);
            HDInsightClusterResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            HDInsightClusterData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // HDInsightClusterResize
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Resize_HDInsightClusterResize()
        {
            // Generated from example definition: specification/hdinsight/resource-manager/Microsoft.HDInsight/HDInsightOnAks/preview/2024-05-01-preview/examples/ResizeCluster.json
            // this example is just showing the usage of "Clusters_Resize" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this HDInsightClusterResource created on azure
            // for more information of creating HDInsightClusterResource, please refer to the document of HDInsightClusterResource
            string subscriptionId = "10e32bab-26da-4cc4-a441-52b318f824e6";
            string resourceGroupName = "hiloResourcegroup";
            string clusterPoolName = "clusterpool1";
            string clusterName = "cluster1";
            ResourceIdentifier hdInsightClusterResourceId = HDInsightClusterResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, clusterPoolName, clusterName);
            HDInsightClusterResource hdInsightCluster = client.GetHDInsightClusterResource(hdInsightClusterResourceId);

            // invoke the operation
            ClusterResizeContent content = new ClusterResizeContent(new AzureLocation("West US 2"))
            {
                ClusterResizeTargetWorkerNodeCount = 5,
            };
            ArmOperation<HDInsightClusterResource> lro = await hdInsightCluster.ResizeAsync(WaitUntil.Completed, content);
            HDInsightClusterResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            HDInsightClusterData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // HDInsightClusterGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_HDInsightClusterGet()
        {
            // Generated from example definition: specification/hdinsight/resource-manager/Microsoft.HDInsight/HDInsightOnAks/preview/2024-05-01-preview/examples/GetCluster.json
            // this example is just showing the usage of "Clusters_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this HDInsightClusterResource created on azure
            // for more information of creating HDInsightClusterResource, please refer to the document of HDInsightClusterResource
            string subscriptionId = "10e32bab-26da-4cc4-a441-52b318f824e6";
            string resourceGroupName = "hiloResourcegroup";
            string clusterPoolName = "clusterpool1";
            string clusterName = "cluster1";
            ResourceIdentifier hdInsightClusterResourceId = HDInsightClusterResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, clusterPoolName, clusterName);
            HDInsightClusterResource hdInsightCluster = client.GetHDInsightClusterResource(hdInsightClusterResourceId);

            // invoke the operation
            HDInsightClusterResource result = await hdInsightCluster.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            HDInsightClusterData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // HDInsightClustersPatchTags
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_HDInsightClustersPatchTags()
        {
            // Generated from example definition: specification/hdinsight/resource-manager/Microsoft.HDInsight/HDInsightOnAks/preview/2024-05-01-preview/examples/PatchCluster.json
            // this example is just showing the usage of "Clusters_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this HDInsightClusterResource created on azure
            // for more information of creating HDInsightClusterResource, please refer to the document of HDInsightClusterResource
            string subscriptionId = "10e32bab-26da-4cc4-a441-52b318f824e6";
            string resourceGroupName = "hiloResourcegroup";
            string clusterPoolName = "clusterpool1";
            string clusterName = "cluster1";
            ResourceIdentifier hdInsightClusterResourceId = HDInsightClusterResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, clusterPoolName, clusterName);
            HDInsightClusterResource hdInsightCluster = client.GetHDInsightClusterResource(hdInsightClusterResourceId);

            // invoke the operation
            HDInsightClusterPatch patch = new HDInsightClusterPatch()
            {
                ClusterProfile = new UpdatableClusterProfile()
                {
                    ServiceConfigsProfiles =
{
new ClusterServiceConfigsProfile("TestService1",new ClusterServiceConfig[]
{
new ClusterServiceConfig("TestComp1",new ClusterConfigFile[]
{
new ClusterConfigFile("TestFile1")
{
Values =
{
["Test.config.1"] = "1",
["Test.config.2"] = "2",
},
},new ClusterConfigFile("TestFile2")
{
Values =
{
["Test.config.3"] = "3",
["Test.config.4"] = "4",
},
}
}),new ClusterServiceConfig("TestComp2",new ClusterConfigFile[]
{
new ClusterConfigFile("TestFile3")
{
Content = "TestContent",
Path = "TestPath",
},new ClusterConfigFile("TestFile4")
{
Values =
{
["Test.config.7"] = "7",
["Test.config.8"] = "8",
},
}
})
}),new ClusterServiceConfigsProfile("TestService2",new ClusterServiceConfig[]
{
new ClusterServiceConfig("TestComp3",new ClusterConfigFile[]
{
new ClusterConfigFile("TestFile5")
{
Values =
{
["Test.config.9"] = "9",
},
}
})
})
},
                    SshProfile = new ClusterSshProfile(2),
                    AutoscaleProfile = new ClusterAutoscaleProfile(true)
                    {
                        GracefulDecommissionTimeout = -1,
                        AutoscaleType = ClusterAutoscaleType.ScheduleBased,
                        ScheduleBasedConfig = new ScheduleBasedConfig("Cen. Australia Standard Time", 3, new AutoscaleSchedule[]
            {
new AutoscaleSchedule("00:00","12:00",3,new AutoscaleScheduleDay[]
{
new AutoscaleScheduleDay("Monday, Tuesday, Wednesday")
}),new AutoscaleSchedule("00:00","12:00",3,new AutoscaleScheduleDay[]
{
AutoscaleScheduleDay.Sunday
})
            }),
                    },
                    AuthorizationProfile = new AuthorizationProfile()
                    {
                        UserIds =
{
"Testuser1","Testuser2"
},
                    },
                    LogAnalyticsProfile = new ClusterLogAnalyticsProfile(true)
                    {
                        ApplicationLogs = new ClusterLogAnalyticsApplicationLogs()
                        {
                            IsStdOutEnabled = true,
                            IsStdErrorEnabled = true,
                        },
                        IsMetricsEnabled = true,
                    },
                },
            };
            ArmOperation<HDInsightClusterResource> lro = await hdInsightCluster.UpdateAsync(WaitUntil.Completed, patch);
            HDInsightClusterResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            HDInsightClusterData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // HDInsightRangerClusterPatchTags
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_HDInsightRangerClusterPatchTags()
        {
            // Generated from example definition: specification/hdinsight/resource-manager/Microsoft.HDInsight/HDInsightOnAks/preview/2024-05-01-preview/examples/PatchRangerCluster.json
            // this example is just showing the usage of "Clusters_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this HDInsightClusterResource created on azure
            // for more information of creating HDInsightClusterResource, please refer to the document of HDInsightClusterResource
            string subscriptionId = "10e32bab-26da-4cc4-a441-52b318f824e6";
            string resourceGroupName = "hiloResourcegroup";
            string clusterPoolName = "clusterpool1";
            string clusterName = "cluster1";
            ResourceIdentifier hdInsightClusterResourceId = HDInsightClusterResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, clusterPoolName, clusterName);
            HDInsightClusterResource hdInsightCluster = client.GetHDInsightClusterResource(hdInsightClusterResourceId);

            // invoke the operation
            HDInsightClusterPatch patch = new HDInsightClusterPatch()
            {
                ClusterProfile = new UpdatableClusterProfile()
                {
                    RangerProfile = new RangerProfile(new RangerAdminSpec(new string[]
            {
"testuser1@contoso.com","testuser2@contoso.com"
            }, new RangerAdminSpecDatabase("testsqlserver.database.windows.net", "testdb")
            {
                PasswordSecretRef = "https://testkv.vault.azure.net/secrets/mysecret/5df6584d9c25418c8d900240aa6c3452",
                Username = "admin",
            }), new RangerUsersyncSpec()
            {
                IsEnabled = true,
                Groups =
            {
"0a53828f-36c9-44c3-be3d-99a7fce977ad","13be6971-79db-4f33-9d41-b25589ca25ac"
            },
                Mode = RangerUsersyncMode.Automatic,
                Users =
            {
"testuser1@contoso.com","testuser2@contoso.com"
            },
            })
                    {
                        RangerAuditStorageAccount = "https://teststorage.blob.core.windows.net/testblob",
                    },
                },
            };
            ArmOperation<HDInsightClusterResource> lro = await hdInsightCluster.UpdateAsync(WaitUntil.Completed, patch);
            HDInsightClusterResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            HDInsightClusterData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // HDInsightClustersDelete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_HDInsightClustersDelete()
        {
            // Generated from example definition: specification/hdinsight/resource-manager/Microsoft.HDInsight/HDInsightOnAks/preview/2024-05-01-preview/examples/DeleteCluster.json
            // this example is just showing the usage of "Clusters_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this HDInsightClusterResource created on azure
            // for more information of creating HDInsightClusterResource, please refer to the document of HDInsightClusterResource
            string subscriptionId = "10e32bab-26da-4cc4-a441-52b318f824e6";
            string resourceGroupName = "rg1";
            string clusterPoolName = "clusterpool1";
            string clusterName = "cluster1";
            ResourceIdentifier hdInsightClusterResourceId = HDInsightClusterResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, clusterPoolName, clusterName);
            HDInsightClusterResource hdInsightCluster = client.GetHDInsightClusterResource(hdInsightClusterResourceId);

            // invoke the operation
            await hdInsightCluster.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // HDInsightClusterGetServiceConfigs
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetServiceConfigs_HDInsightClusterGetServiceConfigs()
        {
            // Generated from example definition: specification/hdinsight/resource-manager/Microsoft.HDInsight/HDInsightOnAks/preview/2024-05-01-preview/examples/ListClusterServiceConfigs.json
            // this example is just showing the usage of "Clusters_ListServiceConfigs" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this HDInsightClusterResource created on azure
            // for more information of creating HDInsightClusterResource, please refer to the document of HDInsightClusterResource
            string subscriptionId = "10e32bab-26da-4cc4-a441-52b318f824e6";
            string resourceGroupName = "rg1";
            string clusterPoolName = "clusterPool1";
            string clusterName = "cluster1";
            ResourceIdentifier hdInsightClusterResourceId = HDInsightClusterResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, clusterPoolName, clusterName);
            HDInsightClusterResource hdInsightCluster = client.GetHDInsightClusterResource(hdInsightClusterResourceId);

            // invoke the operation and iterate over the result
            await foreach (ClusterServiceConfigResult item in hdInsightCluster.GetServiceConfigsAsync())
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // HDInsightClusterGetInstanceViews
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetInstanceViews_HDInsightClusterGetInstanceViews()
        {
            // Generated from example definition: specification/hdinsight/resource-manager/Microsoft.HDInsight/HDInsightOnAks/preview/2024-05-01-preview/examples/ListClusterInstanceViews.json
            // this example is just showing the usage of "Clusters_ListInstanceViews" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this HDInsightClusterResource created on azure
            // for more information of creating HDInsightClusterResource, please refer to the document of HDInsightClusterResource
            string subscriptionId = "10e32bab-26da-4cc4-a441-52b318f824e6";
            string resourceGroupName = "rg1";
            string clusterPoolName = "clusterPool1";
            string clusterName = "cluster1";
            ResourceIdentifier hdInsightClusterResourceId = HDInsightClusterResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, clusterPoolName, clusterName);
            HDInsightClusterResource hdInsightCluster = client.GetHDInsightClusterResource(hdInsightClusterResourceId);

            // invoke the operation and iterate over the result
            await foreach (ClusterInstanceViewResult item in hdInsightCluster.GetInstanceViewsAsync())
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // HDInsightClusterGetInstanceView
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetInstanceView_HDInsightClusterGetInstanceView()
        {
            // Generated from example definition: specification/hdinsight/resource-manager/Microsoft.HDInsight/HDInsightOnAks/preview/2024-05-01-preview/examples/GetClusterInstanceView.json
            // this example is just showing the usage of "Clusters_GetInstanceView" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this HDInsightClusterResource created on azure
            // for more information of creating HDInsightClusterResource, please refer to the document of HDInsightClusterResource
            string subscriptionId = "10e32bab-26da-4cc4-a441-52b318f824e6";
            string resourceGroupName = "rg1";
            string clusterPoolName = "clusterPool1";
            string clusterName = "cluster1";
            ResourceIdentifier hdInsightClusterResourceId = HDInsightClusterResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, clusterPoolName, clusterName);
            HDInsightClusterResource hdInsightCluster = client.GetHDInsightClusterResource(hdInsightClusterResourceId);

            // invoke the operation
            ClusterInstanceViewResult result = await hdInsightCluster.GetInstanceViewAsync();

            Console.WriteLine($"Succeeded: {result}");
        }

        // GetClusterAvailableUpgrade
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetClusterAvailableUpgrades_GetClusterAvailableUpgrade()
        {
            // Generated from example definition: specification/hdinsight/resource-manager/Microsoft.HDInsight/HDInsightOnAks/preview/2024-05-01-preview/examples/ListClusterAvailableUpgrades.json
            // this example is just showing the usage of "ClusterAvailableUpgrades_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this HDInsightClusterResource created on azure
            // for more information of creating HDInsightClusterResource, please refer to the document of HDInsightClusterResource
            string subscriptionId = "10e32bab-26da-4cc4-a441-52b318f824e6";
            string resourceGroupName = "hiloResourcegroup";
            string clusterPoolName = "clusterpool1";
            string clusterName = "cluster1";
            ResourceIdentifier hdInsightClusterResourceId = HDInsightClusterResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, clusterPoolName, clusterName);
            HDInsightClusterResource hdInsightCluster = client.GetHDInsightClusterResource(hdInsightClusterResourceId);

            // invoke the operation and iterate over the result
            await foreach (ClusterAvailableUpgrade item in hdInsightCluster.GetClusterAvailableUpgradesAsync())
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // ClusterUpgradeHistoriesListResult
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetClusterUpgradeHistories_ClusterUpgradeHistoriesListResult()
        {
            // Generated from example definition: specification/hdinsight/resource-manager/Microsoft.HDInsight/HDInsightOnAks/preview/2024-05-01-preview/examples/ListClusterUpgradeHistory.json
            // this example is just showing the usage of "ClusterUpgradeHistories_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this HDInsightClusterResource created on azure
            // for more information of creating HDInsightClusterResource, please refer to the document of HDInsightClusterResource
            string subscriptionId = "10e32bab-26da-4cc4-a441-52b318f824e6";
            string resourceGroupName = "hiloResourcegroup";
            string clusterPoolName = "clusterpool1";
            string clusterName = "cluster1";
            ResourceIdentifier hdInsightClusterResourceId = HDInsightClusterResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, clusterPoolName, clusterName);
            HDInsightClusterResource hdInsightCluster = client.GetHDInsightClusterResource(hdInsightClusterResourceId);

            // invoke the operation and iterate over the result
            await foreach (ClusterUpgradeHistory item in hdInsightCluster.GetClusterUpgradeHistoriesAsync())
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // RunClusterJob
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task RunJobClusterJob_RunClusterJob()
        {
            // Generated from example definition: specification/hdinsight/resource-manager/Microsoft.HDInsight/HDInsightOnAks/preview/2024-05-01-preview/examples/RunClusterJob.json
            // this example is just showing the usage of "ClusterJobs_RunJob" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this HDInsightClusterResource created on azure
            // for more information of creating HDInsightClusterResource, please refer to the document of HDInsightClusterResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "hiloResourcegroup";
            string clusterPoolName = "clusterpool1";
            string clusterName = "cluster1";
            ResourceIdentifier hdInsightClusterResourceId = HDInsightClusterResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, clusterPoolName, clusterName);
            HDInsightClusterResource hdInsightCluster = client.GetHDInsightClusterResource(hdInsightClusterResourceId);

            // invoke the operation
            ClusterJob clusterJob = new ClusterJob(new FlinkJobProperties()
            {
                JobName = "flink-job-name",
                JobJarDirectory = "abfs://flinkjob@hilosa.dfs.core.windows.net/jars",
                JarName = "flink-sleep-job-0.0.1-SNAPSHOT.jar",
                EntryClass = "com.microsoft.hilo.flink.job.streaming.SleepJob",
                Action = FlinkJobAction.Start,
                FlinkConfiguration =
{
["parallelism"] = "1",
["savepoint.directory"] = "abfs://flinkjob@hilosa.dfs.core.windows.net/savepoint",
},
            });
            ArmOperation<ClusterJob> lro = await hdInsightCluster.RunJobClusterJobAsync(WaitUntil.Completed, clusterJob);
            ClusterJob result = lro.Value;

            Console.WriteLine($"Succeeded: {result}");
        }

        // ListClusterJobs
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetClusterJobs_ListClusterJobs()
        {
            // Generated from example definition: specification/hdinsight/resource-manager/Microsoft.HDInsight/HDInsightOnAks/preview/2024-05-01-preview/examples/ListClusterJobs.json
            // this example is just showing the usage of "ClusterJobs_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this HDInsightClusterResource created on azure
            // for more information of creating HDInsightClusterResource, please refer to the document of HDInsightClusterResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "hiloResourcegroup";
            string clusterPoolName = "clusterPool1";
            string clusterName = "cluster1";
            ResourceIdentifier hdInsightClusterResourceId = HDInsightClusterResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, clusterPoolName, clusterName);
            HDInsightClusterResource hdInsightCluster = client.GetHDInsightClusterResource(hdInsightClusterResourceId);

            // invoke the operation and iterate over the result
            await foreach (ClusterJob item in hdInsightCluster.GetClusterJobsAsync())
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // ListPredefinedClusterLibraries
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetClusterLibraries_ListPredefinedClusterLibraries()
        {
            // Generated from example definition: specification/hdinsight/resource-manager/Microsoft.HDInsight/HDInsightOnAks/preview/2024-05-01-preview/examples/ListPredefinedClusterLibraries.json
            // this example is just showing the usage of "ClusterLibraries_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this HDInsightClusterResource created on azure
            // for more information of creating HDInsightClusterResource, please refer to the document of HDInsightClusterResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "hiloResourceGroup";
            string clusterPoolName = "clusterPool";
            string clusterName = "cluster";
            ResourceIdentifier hdInsightClusterResourceId = HDInsightClusterResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, clusterPoolName, clusterName);
            HDInsightClusterResource hdInsightCluster = client.GetHDInsightClusterResource(hdInsightClusterResourceId);

            // invoke the operation and iterate over the result
            ClusterLibraryCategory category = ClusterLibraryCategory.Predefined;
            await foreach (ClusterLibrary item in hdInsightCluster.GetClusterLibrariesAsync(category))
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // ListUserCustomClusterLibraries
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetClusterLibraries_ListUserCustomClusterLibraries()
        {
            // Generated from example definition: specification/hdinsight/resource-manager/Microsoft.HDInsight/HDInsightOnAks/preview/2024-05-01-preview/examples/ListUserCustomClusterLibraries.json
            // this example is just showing the usage of "ClusterLibraries_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this HDInsightClusterResource created on azure
            // for more information of creating HDInsightClusterResource, please refer to the document of HDInsightClusterResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "hiloResourceGroup";
            string clusterPoolName = "clusterPool";
            string clusterName = "cluster";
            ResourceIdentifier hdInsightClusterResourceId = HDInsightClusterResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, clusterPoolName, clusterName);
            HDInsightClusterResource hdInsightCluster = client.GetHDInsightClusterResource(hdInsightClusterResourceId);

            // invoke the operation and iterate over the result
            ClusterLibraryCategory category = ClusterLibraryCategory.Custom;
            await foreach (ClusterLibrary item in hdInsightCluster.GetClusterLibrariesAsync(category))
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // InstallNewClusterLibraries
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task ManageLibrariesClusterLibrary_InstallNewClusterLibraries()
        {
            // Generated from example definition: specification/hdinsight/resource-manager/Microsoft.HDInsight/HDInsightOnAks/preview/2024-05-01-preview/examples/InstallNewClusterLibraries.json
            // this example is just showing the usage of "ClusterLibraries_ManageLibraries" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this HDInsightClusterResource created on azure
            // for more information of creating HDInsightClusterResource, please refer to the document of HDInsightClusterResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "hiloResourceGroup";
            string clusterPoolName = "clusterPool";
            string clusterName = "cluster";
            ResourceIdentifier hdInsightClusterResourceId = HDInsightClusterResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, clusterPoolName, clusterName);
            HDInsightClusterResource hdInsightCluster = client.GetHDInsightClusterResource(hdInsightClusterResourceId);

            // invoke the operation
            ClusterLibraryManagementOperationContent content = new ClusterLibraryManagementOperationContent(new ClusterLibraryManagementOperationProperties(LibraryManagementAction.Install, new ClusterLibrary[]
            {
new ClusterLibrary(new ClusterPyPILibraryProperties("requests")
{
Version = "2.31.0",
Remarks = "PyPi packages.",
}),new ClusterLibrary(new ClusterMavenLibraryProperties("org.apache.flink","flink-connector-kafka")
{
Version = "3.0.2-1.18",
Remarks = "Maven packages.",
})
            }));
            await hdInsightCluster.ManageLibrariesClusterLibraryAsync(WaitUntil.Completed, content);

            Console.WriteLine($"Succeeded");
        }

        // UninstallExistingClusterLibraries
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task ManageLibrariesClusterLibrary_UninstallExistingClusterLibraries()
        {
            // Generated from example definition: specification/hdinsight/resource-manager/Microsoft.HDInsight/HDInsightOnAks/preview/2024-05-01-preview/examples/UninstallExistingClusterLibraries.json
            // this example is just showing the usage of "ClusterLibraries_ManageLibraries" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this HDInsightClusterResource created on azure
            // for more information of creating HDInsightClusterResource, please refer to the document of HDInsightClusterResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "hiloResourceGroup";
            string clusterPoolName = "clusterPool";
            string clusterName = "cluster";
            ResourceIdentifier hdInsightClusterResourceId = HDInsightClusterResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, clusterPoolName, clusterName);
            HDInsightClusterResource hdInsightCluster = client.GetHDInsightClusterResource(hdInsightClusterResourceId);

            // invoke the operation
            ClusterLibraryManagementOperationContent content = new ClusterLibraryManagementOperationContent(new ClusterLibraryManagementOperationProperties(LibraryManagementAction.Uninstall, new ClusterLibrary[]
            {
new ClusterLibrary(new ClusterPyPILibraryProperties("tensorflow")),new ClusterLibrary(new ClusterMavenLibraryProperties("org.apache.flink","flink-connector-hudi"))
            }));
            await hdInsightCluster.ManageLibrariesClusterLibraryAsync(WaitUntil.Completed, content);

            Console.WriteLine($"Succeeded");
        }
    }
}
