// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.HDInsight.Job.Models
{
    using Newtonsoft.Json;
    using System.Linq;

    /// <summary>
    /// Gets or sets the object containing the job status information.
    /// </summary>
    public partial class Status
    {
        /// <summary>
        /// Initializes a new instance of the Status class.
        /// </summary>
        public Status()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the Status class.
        /// </summary>
        /// <param name="cleanupProgress">The progress made on the
        /// cleanup.</param>
        /// <param name="failureInfo">The information about any failures that
        /// have occurred.</param>
        /// <param name="finishTime">The time at which the job completed. It is
        /// an integer in milliseconds, as a Unix timestamp relative to
        /// 1/1/1970 00:00:00.</param>
        /// <param name="historyFile">The history file of the job.</param>
        /// <param name="jobACLs">The ACLs of the job.</param>
        /// <param name="jobComplete">Whether or not the job has
        /// completed.</param>
        /// <param name="jobFile">The job configuration file.</param>
        /// <param name="jobId">The full ID of the job.</param>
        /// <param name="jobID">The ID of the job.</param>
        /// <param name="jobName">The user-specified job name.</param>
        /// <param name="jobPriority">The priority of the job.</param>
        /// <param name="mapProgress">The progress made on the maps.</param>
        /// <param name="neededMem">The amount of memory needed for the
        /// job.</param>
        /// <param name="numReservedSlots">The number of slots
        /// reserved.</param>
        /// <param name="numUsedSlots">The number of slots used for the
        /// job.</param>
        /// <param name="priority">The priority of the job.</param>
        /// <param name="queue">The job queue name.</param>
        /// <param name="reduceProgress">The progress made on the
        /// reduces.</param>
        /// <param name="reservedMem">The amount of memory reserved for the
        /// job.</param>
        /// <param name="retired">Whether or not the job has been retired.
        /// </param>
        /// <param name="runState">The current state of the job.</param>
        /// <param name="schedulingInfo">The information about the scheduling
        /// of the job.</param>
        /// <param name="setupProgress">The progress made on the setup.</param>
        /// <param name="startTime">The time at which the job started. It is an
        /// integer in milliseconds, as a Unix timestamp relative to 1/1/1970
        /// 00:00:00.</param>
        /// <param name="state">The state of the job.</param>
        /// <param name="trackingUrl">The link to the web-ui for details of the
        /// job.</param>
        /// <param name="uber">Whether job running in uber mode.</param>
        /// <param name="usedMem">The amount of memory used by the job.</param>
        /// <param name="username">The userid of the person who submitted the
        /// job.</param>
        public Status(double? cleanupProgress = default(double?), string failureInfo = default(string), long? finishTime = default(long?), string historyFile = default(string), object jobACLs = default(object), bool? jobComplete = default(bool?), string jobFile = default(string), string jobId = default(string), JobID jobID = default(JobID), string jobName = default(string), string jobPriority = default(string), double? mapProgress = default(double?), long? neededMem = default(long?), int? numReservedSlots = default(int?), int? numUsedSlots = default(int?), string priority = default(string), string queue = default(string), double? reduceProgress = default(double?), long? reservedMem = default(long?), bool? retired = default(bool?), int? runState = default(int?), string schedulingInfo = default(string), double? setupProgress = default(double?), long? startTime = default(long?), string state = default(string), string trackingUrl = default(string), bool? uber = default(bool?), long? usedMem = default(long?), string username = default(string))
        {
            CleanupProgress = cleanupProgress;
            FailureInfo = failureInfo;
            FinishTime = finishTime;
            HistoryFile = historyFile;
            JobACLs = jobACLs;
            JobComplete = jobComplete;
            JobFile = jobFile;
            JobId = jobId;
            JobID = jobID;
            JobName = jobName;
            JobPriority = jobPriority;
            MapProgress = mapProgress;
            NeededMem = neededMem;
            NumReservedSlots = numReservedSlots;
            NumUsedSlots = numUsedSlots;
            Priority = priority;
            Queue = queue;
            ReduceProgress = reduceProgress;
            ReservedMem = reservedMem;
            Retired = retired;
            RunState = runState;
            SchedulingInfo = schedulingInfo;
            SetupProgress = setupProgress;
            StartTime = startTime;
            State = state;
            TrackingUrl = trackingUrl;
            Uber = uber;
            UsedMem = usedMem;
            Username = username;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets the progress made on the cleanup.
        /// </summary>
        [JsonProperty(PropertyName = "cleanupProgress")]
        public double? CleanupProgress { get; set; }

        /// <summary>
        /// Gets or sets the information about any failures that have occurred.
        /// </summary>
        [JsonProperty(PropertyName = "failureInfo")]
        public string FailureInfo { get; set; }

        /// <summary>
        /// Gets or sets the time at which the job completed. It is an integer
        /// in milliseconds, as a Unix timestamp relative to 1/1/1970 00:00:00.
        /// </summary>
        [JsonProperty(PropertyName = "finishTime")]
        public long? FinishTime { get; set; }

        /// <summary>
        /// Gets or sets the history file of the job.
        /// </summary>
        [JsonProperty(PropertyName = "historyFile")]
        public string HistoryFile { get; set; }

        /// <summary>
        /// Gets or sets the ACLs of the job.
        /// </summary>
        [JsonProperty(PropertyName = "jobACLs")]
        public object JobACLs { get; set; }

        /// <summary>
        /// Gets or sets whether or not the job has completed.
        /// </summary>
        [JsonProperty(PropertyName = "jobComplete")]
        public bool? JobComplete { get; set; }

        /// <summary>
        /// Gets or sets the job configuration file.
        /// </summary>
        [JsonProperty(PropertyName = "jobFile")]
        public string JobFile { get; set; }

        /// <summary>
        /// Gets or sets the full ID of the job.
        /// </summary>
        [JsonProperty(PropertyName = "jobId")]
        public string JobId { get; set; }

        /// <summary>
        /// Gets or sets the ID of the job.
        /// </summary>
        [JsonProperty(PropertyName = "jobID")]
        public JobID JobID { get; set; }

        /// <summary>
        /// Gets or sets the user-specified job name.
        /// </summary>
        [JsonProperty(PropertyName = "jobName")]
        public string JobName { get; set; }

        /// <summary>
        /// Gets or sets the priority of the job.
        /// </summary>
        [JsonProperty(PropertyName = "jobPriority")]
        public string JobPriority { get; set; }

        /// <summary>
        /// Gets or sets the progress made on the maps.
        /// </summary>
        [JsonProperty(PropertyName = "mapProgress")]
        public double? MapProgress { get; set; }

        /// <summary>
        /// Gets or sets the amount of memory needed for the job.
        /// </summary>
        [JsonProperty(PropertyName = "neededMem")]
        public long? NeededMem { get; set; }

        /// <summary>
        /// Gets or sets the number of slots reserved.
        /// </summary>
        [JsonProperty(PropertyName = "numReservedSlots")]
        public int? NumReservedSlots { get; set; }

        /// <summary>
        /// Gets or sets the number of slots used for the job.
        /// </summary>
        [JsonProperty(PropertyName = "numUsedSlots")]
        public int? NumUsedSlots { get; set; }

        /// <summary>
        /// Gets or sets the priority of the job.
        /// </summary>
        [JsonProperty(PropertyName = "priority")]
        public string Priority { get; set; }

        /// <summary>
        /// Gets or sets the job queue name.
        /// </summary>
        [JsonProperty(PropertyName = "queue")]
        public string Queue { get; set; }

        /// <summary>
        /// Gets or sets the progress made on the reduces.
        /// </summary>
        [JsonProperty(PropertyName = "reduceProgress")]
        public double? ReduceProgress { get; set; }

        /// <summary>
        /// Gets or sets the amount of memory reserved for the job.
        /// </summary>
        [JsonProperty(PropertyName = "reservedMem")]
        public long? ReservedMem { get; set; }

        /// <summary>
        /// Gets or sets whether or not the job has been retired.
        /// </summary>
        [JsonProperty(PropertyName = "retired")]
        public bool? Retired { get; set; }

        /// <summary>
        /// Gets or sets the current state of the job.
        /// </summary>
        [JsonProperty(PropertyName = "runState")]
        public int? RunState { get; set; }

        /// <summary>
        /// Gets or sets the information about the scheduling of the job.
        /// </summary>
        [JsonProperty(PropertyName = "schedulingInfo")]
        public string SchedulingInfo { get; set; }

        /// <summary>
        /// Gets or sets the progress made on the setup.
        /// </summary>
        [JsonProperty(PropertyName = "setupProgress")]
        public double? SetupProgress { get; set; }

        /// <summary>
        /// Gets or sets the time at which the job started. It is an integer in
        /// milliseconds, as a Unix timestamp relative to 1/1/1970 00:00:00.
        /// </summary>
        [JsonProperty(PropertyName = "startTime")]
        public long? StartTime { get; set; }

        /// <summary>
        /// Gets or sets the state of the job.
        /// </summary>
        [JsonProperty(PropertyName = "state")]
        public string State { get; set; }

        /// <summary>
        /// Gets or sets the link to the web-ui for details of the job.
        /// </summary>
        [JsonProperty(PropertyName = "trackingUrl")]
        public string TrackingUrl { get; set; }

        /// <summary>
        /// Gets or sets whether job running in uber mode.
        /// </summary>
        [JsonProperty(PropertyName = "uber")]
        public bool? Uber { get; set; }

        /// <summary>
        /// Gets or sets the amount of memory used by the job.
        /// </summary>
        [JsonProperty(PropertyName = "usedMem")]
        public long? UsedMem { get; set; }

        /// <summary>
        /// Gets or sets the userid of the person who submitted the job.
        /// </summary>
        [JsonProperty(PropertyName = "username")]
        public string Username { get; set; }

    }
}
