// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.HDInsight.Job.Models
{
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    public partial class SparkSessionJob
    {
        /// <summary>
        /// Initializes a new instance of the SparkSessionJob class.
        /// </summary>
        public SparkSessionJob()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the SparkSessionJob class.
        /// </summary>
        /// <param name="id">The livy id of the spark session job.</param>
        /// <param name="appId">The application id of this job.</param>
        /// <param name="owner">Remote user who submitted this job.</param>
        /// <param name="proxyUser">User to impersonate when running.</param>
        /// <param name="kind">Spark session job kind. Possible values include:
        /// 'spark', 'pyspark', 'sparkr', 'sql'</param>
        /// <param name="logLines">The log lines.</param>
        /// <param name="state">The current state of the spark session job.
        /// Possible values include: 'not_started', 'starting', 'idle',
        /// 'running', 'busy', 'shutting_down', 'error', 'dead', 'killed',
        /// 'success', 'recovering'</param>
        /// <param name="appInfo">The detailed application info.</param>
        public SparkSessionJob(int? id = default(int?), string appId = default(string), string owner = default(string), string proxyUser = default(string), string kind = default(string), IList<string> logLines = default(IList<string>), string state = default(string), IDictionary<string, string> appInfo = default(IDictionary<string, string>))
        {
            Id = id;
            AppId = appId;
            Owner = owner;
            ProxyUser = proxyUser;
            Kind = kind;
            LogLines = logLines;
            State = state;
            AppInfo = appInfo;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets the livy id of the spark session job.
        /// </summary>
        [JsonProperty(PropertyName = "id")]
        public int? Id { get; set; }

        /// <summary>
        /// Gets or sets the application id of this job.
        /// </summary>
        [JsonProperty(PropertyName = "appId")]
        public string AppId { get; set; }

        /// <summary>
        /// Gets or sets remote user who submitted this job.
        /// </summary>
        [JsonProperty(PropertyName = "owner")]
        public string Owner { get; set; }

        /// <summary>
        /// Gets or sets user to impersonate when running.
        /// </summary>
        [JsonProperty(PropertyName = "proxyUser")]
        public string ProxyUser { get; set; }

        /// <summary>
        /// Gets or sets spark session job kind. Possible values include:
        /// 'spark', 'pyspark', 'sparkr', 'sql'
        /// </summary>
        [JsonProperty(PropertyName = "kind")]
        public string Kind { get; set; }

        /// <summary>
        /// Gets or sets the log lines.
        /// </summary>
        [JsonProperty(PropertyName = "log")]
        public IList<string> LogLines { get; set; }

        /// <summary>
        /// Gets or sets the current state of the spark session job. Possible
        /// values include: 'not_started', 'starting', 'idle', 'running',
        /// 'busy', 'shutting_down', 'error', 'dead', 'killed', 'success',
        /// 'recovering'
        /// </summary>
        [JsonProperty(PropertyName = "state")]
        public string State { get; set; }

        /// <summary>
        /// Gets or sets the detailed application info.
        /// </summary>
        [JsonProperty(PropertyName = "appInfo")]
        public IDictionary<string, string> AppInfo { get; set; }

    }
}
