// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.HDInsight.Job
{
    using Microsoft.Rest;
    using Microsoft.Rest.Azure;
    using Models;
    using System.Collections;
    using System.Collections.Generic;
    using System.IO;
    using System.Threading;
    using System.Threading.Tasks;

    /// <summary>
    /// Extension methods for JobOperations.
    /// </summary>
    public static partial class JobOperationsExtensions
    {
            /// <summary>
            /// Gets job details from the specified HDInsight cluster.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='jobId'>
            /// The id of the job.
            /// </param>
            public static JobDetailRootJsonObject Get(this IJobOperations operations, string jobId)
            {
                return operations.GetAsync(jobId).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Gets job details from the specified HDInsight cluster.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='jobId'>
            /// The id of the job.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<JobDetailRootJsonObject> GetAsync(this IJobOperations operations, string jobId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetWithHttpMessagesAsync(jobId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Initiates cancel on given running job in the specified HDInsight.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='jobId'>
            /// The id of the job.
            /// </param>
            public static JobDetailRootJsonObject Kill(this IJobOperations operations, string jobId)
            {
                return operations.KillAsync(jobId).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Initiates cancel on given running job in the specified HDInsight.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='jobId'>
            /// The id of the job.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<JobDetailRootJsonObject> KillAsync(this IJobOperations operations, string jobId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.KillWithHttpMessagesAsync(jobId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Gets the list of jobs from the specified HDInsight cluster.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            public static IList<JobListJsonObject> List(this IJobOperations operations)
            {
                return operations.ListAsync().GetAwaiter().GetResult();
            }

            /// <summary>
            /// Gets the list of jobs from the specified HDInsight cluster.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IList<JobListJsonObject>> ListAsync(this IJobOperations operations, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ListWithHttpMessagesAsync(null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Gets numrecords Of Jobs after jobid from the specified HDInsight cluster.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='jobid'>
            /// JobId from where to list jobs.
            /// </param>
            /// <param name='numrecords'>
            /// Number of jobs to fetch.
            /// </param>
            public static IList<JobListJsonObject> ListAfterJobId(this IJobOperations operations, string jobid = default(string), int? numrecords = default(int?))
            {
                return operations.ListAfterJobIdAsync(jobid, numrecords).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Gets numrecords Of Jobs after jobid from the specified HDInsight cluster.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='jobid'>
            /// JobId from where to list jobs.
            /// </param>
            /// <param name='numrecords'>
            /// Number of jobs to fetch.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IList<JobListJsonObject>> ListAfterJobIdAsync(this IJobOperations operations, string jobid = default(string), int? numrecords = default(int?), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ListAfterJobIdWithHttpMessagesAsync(jobid, numrecords, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Submits a Hive job to an HDInsight cluster.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='content'>
            /// The content of the Hive job request.
            /// </param>
            public static JobSubmissionJsonResponse SubmitHiveJob(this IJobOperations operations, Stream content)
            {
                return operations.SubmitHiveJobAsync(content).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Submits a Hive job to an HDInsight cluster.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='content'>
            /// The content of the Hive job request.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<JobSubmissionJsonResponse> SubmitHiveJobAsync(this IJobOperations operations, Stream content, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.SubmitHiveJobWithHttpMessagesAsync(content, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Submits a MapReduce job to an HDInsight cluster.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='content'>
            /// The content of the MapReduce job request.
            /// </param>
            public static JobSubmissionJsonResponse SubmitMapReduceJob(this IJobOperations operations, Stream content)
            {
                return operations.SubmitMapReduceJobAsync(content).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Submits a MapReduce job to an HDInsight cluster.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='content'>
            /// The content of the MapReduce job request.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<JobSubmissionJsonResponse> SubmitMapReduceJobAsync(this IJobOperations operations, Stream content, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.SubmitMapReduceJobWithHttpMessagesAsync(content, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Submits a MapReduce streaming job to an HDInsight cluster.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='content'>
            /// The content of the MapReduce job request.
            /// </param>
            public static JobSubmissionJsonResponse SubmitMapReduceStreamingJob(this IJobOperations operations, Stream content)
            {
                return operations.SubmitMapReduceStreamingJobAsync(content).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Submits a MapReduce streaming job to an HDInsight cluster.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='content'>
            /// The content of the MapReduce job request.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<JobSubmissionJsonResponse> SubmitMapReduceStreamingJobAsync(this IJobOperations operations, Stream content, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.SubmitMapReduceStreamingJobWithHttpMessagesAsync(content, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Submits a Pig job to an HDInsight cluster.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='content'>
            /// The content of the Pig job request.
            /// </param>
            public static JobSubmissionJsonResponse SubmitPigJob(this IJobOperations operations, Stream content)
            {
                return operations.SubmitPigJobAsync(content).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Submits a Pig job to an HDInsight cluster.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='content'>
            /// The content of the Pig job request.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<JobSubmissionJsonResponse> SubmitPigJobAsync(this IJobOperations operations, Stream content, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.SubmitPigJobWithHttpMessagesAsync(content, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Submits a Sqoop job to an HDInsight cluster.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='content'>
            /// The content of the Sqoop job request.
            /// </param>
            public static JobSubmissionJsonResponse SubmitSqoopJob(this IJobOperations operations, Stream content)
            {
                return operations.SubmitSqoopJobAsync(content).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Submits a Sqoop job to an HDInsight cluster.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='content'>
            /// The content of the Sqoop job request.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<JobSubmissionJsonResponse> SubmitSqoopJobAsync(this IJobOperations operations, Stream content, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.SubmitSqoopJobWithHttpMessagesAsync(content, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Gets application state from the specified HDInsight cluster.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The id of the job.
            /// </param>
            public static AppState GetAppState(this IJobOperations operations, string appId)
            {
                return operations.GetAppStateAsync(appId).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Gets application state from the specified HDInsight cluster.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='appId'>
            /// The id of the job.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<AppState> GetAppStateAsync(this IJobOperations operations, string appId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetAppStateWithHttpMessagesAsync(appId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// List all spark batch jobs
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='fromParameter'>
            /// Optional param specifying which index the list should begin from.
            /// </param>
            /// <param name='size'>
            /// Optional param specifying the size of the returned list.
            /// By default it is 20 and that is the maximum.
            /// </param>
            public static SparkBatchJobCollection ListSparkBatchJob(this IJobOperations operations, int? fromParameter = default(int?), int? size = default(int?))
            {
                return operations.ListSparkBatchJobAsync(fromParameter, size).GetAwaiter().GetResult();
            }

            /// <summary>
            /// List all spark batch jobs
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='fromParameter'>
            /// Optional param specifying which index the list should begin from.
            /// </param>
            /// <param name='size'>
            /// Optional param specifying the size of the returned list.
            /// By default it is 20 and that is the maximum.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<SparkBatchJobCollection> ListSparkBatchJobAsync(this IJobOperations operations, int? fromParameter = default(int?), int? size = default(int?), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ListSparkBatchJobWithHttpMessagesAsync(fromParameter, size, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Create a new spark batch job.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='sparkBatchJobRequest'>
            /// Livy compatible batch job request payload.
            /// </param>
            /// <param name='requestedBy'>
            /// Add default value for X-Requested-By in header.
            /// </param>
            public static SparkBatchJob SubmitSparkBatchJob(this IJobOperations operations, SparkBatchJobRequest sparkBatchJobRequest, string requestedBy = "ambari")
            {
                return operations.SubmitSparkBatchJobAsync(sparkBatchJobRequest, requestedBy).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Create a new spark batch job.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='sparkBatchJobRequest'>
            /// Livy compatible batch job request payload.
            /// </param>
            /// <param name='requestedBy'>
            /// Add default value for X-Requested-By in header.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<SparkBatchJob> SubmitSparkBatchJobAsync(this IJobOperations operations, SparkBatchJobRequest sparkBatchJobRequest, string requestedBy = "ambari", CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.SubmitSparkBatchJobWithHttpMessagesAsync(sparkBatchJobRequest, requestedBy, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Gets a single spark batch job.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='batchId'>
            /// Identifier for the batch job.
            /// </param>
            public static SparkBatchJob GetSparkBatchJob(this IJobOperations operations, int batchId)
            {
                return operations.GetSparkBatchJobAsync(batchId).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Gets a single spark batch job.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='batchId'>
            /// Identifier for the batch job.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<SparkBatchJob> GetSparkBatchJobAsync(this IJobOperations operations, int batchId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetSparkBatchJobWithHttpMessagesAsync(batchId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Cancels a running spark batch job.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='batchId'>
            /// Identifier for the batch job.
            /// </param>
            /// <param name='requestedBy'>
            /// Add default value for X-Requested-By in header.
            /// </param>
            public static SparkJobDeletedResult DeleteSparkBatchJob(this IJobOperations operations, int batchId, string requestedBy = "ambari")
            {
                return operations.DeleteSparkBatchJobAsync(batchId, requestedBy).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Cancels a running spark batch job.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='batchId'>
            /// Identifier for the batch job.
            /// </param>
            /// <param name='requestedBy'>
            /// Add default value for X-Requested-By in header.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<SparkJobDeletedResult> DeleteSparkBatchJobAsync(this IJobOperations operations, int batchId, string requestedBy = "ambari", CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.DeleteSparkBatchJobWithHttpMessagesAsync(batchId, requestedBy, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Gets a single spark batch job logs.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='batchId'>
            /// Identifier for the batch job.
            /// </param>
            /// <param name='fromParameter'>
            /// Optional param specifying which index the list should begin from.
            /// </param>
            /// <param name='size'>
            /// Optional param specifying the size of the returned list.
            /// By default it is 20 and that is the maximum.
            /// </param>
            public static SparkJobLog GetSparkBatchLog(this IJobOperations operations, int batchId, int? fromParameter = default(int?), int? size = default(int?))
            {
                return operations.GetSparkBatchLogAsync(batchId, fromParameter, size).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Gets a single spark batch job logs.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='batchId'>
            /// Identifier for the batch job.
            /// </param>
            /// <param name='fromParameter'>
            /// Optional param specifying which index the list should begin from.
            /// </param>
            /// <param name='size'>
            /// Optional param specifying the size of the returned list.
            /// By default it is 20 and that is the maximum.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<SparkJobLog> GetSparkBatchLogAsync(this IJobOperations operations, int batchId, int? fromParameter = default(int?), int? size = default(int?), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetSparkBatchLogWithHttpMessagesAsync(batchId, fromParameter, size, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Gets a single spark batch state.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='batchId'>
            /// Identifier for the batch job.
            /// </param>
            public static SparkJobState GetSparkBatchState(this IJobOperations operations, int batchId)
            {
                return operations.GetSparkBatchStateAsync(batchId).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Gets a single spark batch state.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='batchId'>
            /// Identifier for the batch job.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<SparkJobState> GetSparkBatchStateAsync(this IJobOperations operations, int batchId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetSparkBatchStateWithHttpMessagesAsync(batchId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// List all spark sessions.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='fromParameter'>
            /// Optional param specifying which index the list should begin from.
            /// </param>
            /// <param name='size'>
            /// Optional param specifying the size of the returned list.
            /// By default it is 20 and that is the maximum.
            /// </param>
            public static SparkSessionCollection ListSparkSessionJob(this IJobOperations operations, int? fromParameter = default(int?), int? size = default(int?))
            {
                return operations.ListSparkSessionJobAsync(fromParameter, size).GetAwaiter().GetResult();
            }

            /// <summary>
            /// List all spark sessions.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='fromParameter'>
            /// Optional param specifying which index the list should begin from.
            /// </param>
            /// <param name='size'>
            /// Optional param specifying the size of the returned list.
            /// By default it is 20 and that is the maximum.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<SparkSessionCollection> ListSparkSessionJobAsync(this IJobOperations operations, int? fromParameter = default(int?), int? size = default(int?), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ListSparkSessionJobWithHttpMessagesAsync(fromParameter, size, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Create a new spark session.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='sparkSessionJobRequest'>
            /// Livy compatible session job request payload.
            /// </param>
            /// <param name='requestedBy'>
            /// Add default value for X-Requested-By in header.
            /// </param>
            public static SparkSessionJob SubmitSparkSessionJob(this IJobOperations operations, SparkSessionJobRequest sparkSessionJobRequest, string requestedBy = "ambari")
            {
                return operations.SubmitSparkSessionJobAsync(sparkSessionJobRequest, requestedBy).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Create a new spark session.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='sparkSessionJobRequest'>
            /// Livy compatible session job request payload.
            /// </param>
            /// <param name='requestedBy'>
            /// Add default value for X-Requested-By in header.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<SparkSessionJob> SubmitSparkSessionJobAsync(this IJobOperations operations, SparkSessionJobRequest sparkSessionJobRequest, string requestedBy = "ambari", CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.SubmitSparkSessionJobWithHttpMessagesAsync(sparkSessionJobRequest, requestedBy, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Gets a single spark session.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='sessionId'>
            /// Identifier for the session.
            /// </param>
            public static SparkSessionJob GetSparkSessionJob(this IJobOperations operations, int sessionId)
            {
                return operations.GetSparkSessionJobAsync(sessionId).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Gets a single spark session.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='sessionId'>
            /// Identifier for the session.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<SparkSessionJob> GetSparkSessionJobAsync(this IJobOperations operations, int sessionId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetSparkSessionJobWithHttpMessagesAsync(sessionId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Cancels a running spark session.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='sessionId'>
            /// Identifier for the session.
            /// </param>
            /// <param name='requestedBy'>
            /// Add default value for X-Requested-By in header.
            /// </param>
            public static SparkJobDeletedResult DeleteSparkSessionJob(this IJobOperations operations, int sessionId, string requestedBy = "ambari")
            {
                return operations.DeleteSparkSessionJobAsync(sessionId, requestedBy).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Cancels a running spark session.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='sessionId'>
            /// Identifier for the session.
            /// </param>
            /// <param name='requestedBy'>
            /// Add default value for X-Requested-By in header.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<SparkJobDeletedResult> DeleteSparkSessionJobAsync(this IJobOperations operations, int sessionId, string requestedBy = "ambari", CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.DeleteSparkSessionJobWithHttpMessagesAsync(sessionId, requestedBy, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Gets a single spark session job logs.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='sessionId'>
            /// Identifier for the session job.
            /// </param>
            /// <param name='fromParameter'>
            /// Optional param specifying which index the list should begin from.
            /// </param>
            /// <param name='size'>
            /// Optional param specifying the size of the returned list.
            /// By default it is 20 and that is the maximum.
            /// </param>
            public static SparkJobLog GetSparkSessionLog(this IJobOperations operations, int sessionId, int? fromParameter = default(int?), int? size = default(int?))
            {
                return operations.GetSparkSessionLogAsync(sessionId, fromParameter, size).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Gets a single spark session job logs.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='sessionId'>
            /// Identifier for the session job.
            /// </param>
            /// <param name='fromParameter'>
            /// Optional param specifying which index the list should begin from.
            /// </param>
            /// <param name='size'>
            /// Optional param specifying the size of the returned list.
            /// By default it is 20 and that is the maximum.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<SparkJobLog> GetSparkSessionLogAsync(this IJobOperations operations, int sessionId, int? fromParameter = default(int?), int? size = default(int?), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetSparkSessionLogWithHttpMessagesAsync(sessionId, fromParameter, size, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Gets a single spark session job state.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='sessionId'>
            /// Identifier for the session job.
            /// </param>
            public static SparkJobState GetSparkSessionState(this IJobOperations operations, int sessionId)
            {
                return operations.GetSparkSessionStateAsync(sessionId).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Gets a single spark session job state.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='sessionId'>
            /// Identifier for the session job.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<SparkJobState> GetSparkSessionStateAsync(this IJobOperations operations, int sessionId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetSparkSessionStateWithHttpMessagesAsync(sessionId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Gets a list of statements within a spark session.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='sessionId'>
            /// Identifier for the session.
            /// </param>
            public static SparkStatementCollection ListSparkStatementJob(this IJobOperations operations, int sessionId)
            {
                return operations.ListSparkStatementJobAsync(sessionId).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Gets a list of statements within a spark session.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='sessionId'>
            /// Identifier for the session.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<SparkStatementCollection> ListSparkStatementJobAsync(this IJobOperations operations, int sessionId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ListSparkStatementJobWithHttpMessagesAsync(sessionId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Create a statement within a spark session.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='sessionId'>
            /// Identifier for the session.
            /// </param>
            /// <param name='sparkStatementRequest'>
            /// Livy compatible batch job request payload.
            /// </param>
            /// <param name='requestedBy'>
            /// Add default value for X-Requested-By in header.
            /// </param>
            public static SparkStatement SubmitSparkStatementJob(this IJobOperations operations, int sessionId, SparkStatementRequest sparkStatementRequest, string requestedBy = "ambari")
            {
                return operations.SubmitSparkStatementJobAsync(sessionId, sparkStatementRequest, requestedBy).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Create a statement within a spark session.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='sessionId'>
            /// Identifier for the session.
            /// </param>
            /// <param name='sparkStatementRequest'>
            /// Livy compatible batch job request payload.
            /// </param>
            /// <param name='requestedBy'>
            /// Add default value for X-Requested-By in header.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<SparkStatement> SubmitSparkStatementJobAsync(this IJobOperations operations, int sessionId, SparkStatementRequest sparkStatementRequest, string requestedBy = "ambari", CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.SubmitSparkStatementJobWithHttpMessagesAsync(sessionId, sparkStatementRequest, requestedBy, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Gets a single statement within a spark session.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='sessionId'>
            /// Identifier for the session.
            /// </param>
            /// <param name='statementId'>
            /// Identifier for the statement.
            /// </param>
            public static SparkStatement GetSparkStatementJob(this IJobOperations operations, int sessionId, int statementId)
            {
                return operations.GetSparkStatementJobAsync(sessionId, statementId).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Gets a single statement within a spark session.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='sessionId'>
            /// Identifier for the session.
            /// </param>
            /// <param name='statementId'>
            /// Identifier for the statement.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<SparkStatement> GetSparkStatementJobAsync(this IJobOperations operations, int sessionId, int statementId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetSparkStatementJobWithHttpMessagesAsync(sessionId, statementId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Kill a statement within a session.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='sessionId'>
            /// Identifier for the session.
            /// </param>
            /// <param name='statementId'>
            /// Identifier for the statement.
            /// </param>
            /// <param name='requestedBy'>
            /// Add default value for X-Requested-By in header.
            /// </param>
            public static SparkStatementCancellationResult DeleteSparkStatementJob(this IJobOperations operations, int sessionId, int statementId, string requestedBy = "ambari")
            {
                return operations.DeleteSparkStatementJobAsync(sessionId, statementId, requestedBy).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Kill a statement within a session.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='sessionId'>
            /// Identifier for the session.
            /// </param>
            /// <param name='statementId'>
            /// Identifier for the statement.
            /// </param>
            /// <param name='requestedBy'>
            /// Add default value for X-Requested-By in header.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<SparkStatementCancellationResult> DeleteSparkStatementJobAsync(this IJobOperations operations, int sessionId, int statementId, string requestedBy = "ambari", CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.DeleteSparkStatementJobWithHttpMessagesAsync(sessionId, statementId, requestedBy, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

    }
}
