// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HDInsight.Models
{
    /// <summary> The execution summary of a script action. </summary>
    public partial class ScriptActionExecutionSummary
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ScriptActionExecutionSummary"/>. </summary>
        internal ScriptActionExecutionSummary()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ScriptActionExecutionSummary"/>. </summary>
        /// <param name="status"> The status of script action execution. </param>
        /// <param name="instanceCount"> The instance count for a given script action execution status. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ScriptActionExecutionSummary(string status, int? instanceCount, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Status = status;
            InstanceCount = instanceCount;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The status of script action execution. </summary>
        public string Status { get; }
        /// <summary> The instance count for a given script action execution status. </summary>
        public int? InstanceCount { get; }
    }
}
