// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HDInsight.Models
{
    /// <summary> Describes a script action on role on the cluster. </summary>
    public partial class ScriptAction
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ScriptAction"/>. </summary>
        /// <param name="name"> The name of the script action. </param>
        /// <param name="uri"> The URI to the script. </param>
        /// <param name="parameters"> The parameters for the script provided. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/>, <paramref name="uri"/> or <paramref name="parameters"/> is null. </exception>
        public ScriptAction(string name, Uri uri, string parameters)
        {
            Argument.AssertNotNull(name, nameof(name));
            Argument.AssertNotNull(uri, nameof(uri));
            Argument.AssertNotNull(parameters, nameof(parameters));

            Name = name;
            Uri = uri;
            Parameters = parameters;
        }

        /// <summary> Initializes a new instance of <see cref="ScriptAction"/>. </summary>
        /// <param name="name"> The name of the script action. </param>
        /// <param name="uri"> The URI to the script. </param>
        /// <param name="parameters"> The parameters for the script provided. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ScriptAction(string name, Uri uri, string parameters, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            Uri = uri;
            Parameters = parameters;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ScriptAction"/> for deserialization. </summary>
        internal ScriptAction()
        {
        }

        /// <summary> The name of the script action. </summary>
        public string Name { get; set; }
        /// <summary> The URI to the script. </summary>
        public Uri Uri { get; set; }
        /// <summary> The parameters for the script provided. </summary>
        public string Parameters { get; set; }
    }
}
