// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.HDInsight.Models
{
    /// <summary> The regional quota capacity. </summary>
    public partial class RegionalQuotaCapability
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RegionalQuotaCapability"/>. </summary>
        internal RegionalQuotaCapability()
        {
        }

        /// <summary> Initializes a new instance of <see cref="RegionalQuotaCapability"/>. </summary>
        /// <param name="region"> The region name. </param>
        /// <param name="coresUsed"> The number of cores used in the region. </param>
        /// <param name="coresAvailable"> The number of cores available in the region. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RegionalQuotaCapability(AzureLocation? region, long? coresUsed, long? coresAvailable, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Region = region;
            CoresUsed = coresUsed;
            CoresAvailable = coresAvailable;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The region name. </summary>
        public AzureLocation? Region { get; }
        /// <summary> The number of cores used in the region. </summary>
        public long? CoresUsed { get; }
        /// <summary> The number of cores available in the region. </summary>
        public long? CoresAvailable { get; }
    }
}
