// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.HDInsight.Models
{
    public partial class RegionalQuotaCapability : IUtf8JsonSerializable, IJsonModel<RegionalQuotaCapability>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<RegionalQuotaCapability>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<RegionalQuotaCapability>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RegionalQuotaCapability>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(RegionalQuotaCapability)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(Region))
            {
                writer.WritePropertyName("regionName"u8);
                writer.WriteStringValue(Region.Value);
            }
            if (Optional.IsDefined(CoresUsed))
            {
                writer.WritePropertyName("coresUsed"u8);
                writer.WriteNumberValue(CoresUsed.Value);
            }
            if (Optional.IsDefined(CoresAvailable))
            {
                writer.WritePropertyName("coresAvailable"u8);
                writer.WriteNumberValue(CoresAvailable.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        RegionalQuotaCapability IJsonModel<RegionalQuotaCapability>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RegionalQuotaCapability>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(RegionalQuotaCapability)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeRegionalQuotaCapability(document.RootElement, options);
        }

        internal static RegionalQuotaCapability DeserializeRegionalQuotaCapability(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            AzureLocation? regionName = default;
            long? coresUsed = default;
            long? coresAvailable = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("regionName"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    regionName = new AzureLocation(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("coresUsed"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    coresUsed = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("coresAvailable"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    coresAvailable = property.Value.GetInt64();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new RegionalQuotaCapability(regionName, coresUsed, coresAvailable, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<RegionalQuotaCapability>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RegionalQuotaCapability>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(RegionalQuotaCapability)} does not support writing '{options.Format}' format.");
            }
        }

        RegionalQuotaCapability IPersistableModel<RegionalQuotaCapability>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RegionalQuotaCapability>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeRegionalQuotaCapability(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(RegionalQuotaCapability)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<RegionalQuotaCapability>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
