// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HDInsight.Models
{
    /// <summary> A value to describe how the outbound dependencies of a HDInsight cluster are managed. 'Managed' means that the outbound dependencies are managed by the HDInsight service. 'External' means that the outbound dependencies are managed by a customer specific solution. </summary>
    public readonly partial struct OutboundDependenciesManagedType : IEquatable<OutboundDependenciesManagedType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="OutboundDependenciesManagedType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public OutboundDependenciesManagedType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ManagedValue = "Managed";
        private const string ExternalValue = "External";

        /// <summary> Managed. </summary>
        public static OutboundDependenciesManagedType Managed { get; } = new OutboundDependenciesManagedType(ManagedValue);
        /// <summary> External. </summary>
        public static OutboundDependenciesManagedType External { get; } = new OutboundDependenciesManagedType(ExternalValue);
        /// <summary> Determines if two <see cref="OutboundDependenciesManagedType"/> values are the same. </summary>
        public static bool operator ==(OutboundDependenciesManagedType left, OutboundDependenciesManagedType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="OutboundDependenciesManagedType"/> values are not the same. </summary>
        public static bool operator !=(OutboundDependenciesManagedType left, OutboundDependenciesManagedType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="OutboundDependenciesManagedType"/>. </summary>
        public static implicit operator OutboundDependenciesManagedType(string value) => new OutboundDependenciesManagedType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is OutboundDependenciesManagedType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(OutboundDependenciesManagedType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
