// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HDInsight.Models
{
    /// <summary> The kafka rest proxy configuration which contains AAD security group information. </summary>
    public partial class KafkaRestProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="KafkaRestProperties"/>. </summary>
        public KafkaRestProperties()
        {
            ConfigurationOverride = new ChangeTrackingDictionary<string, string>();
        }

        /// <summary> Initializes a new instance of <see cref="KafkaRestProperties"/>. </summary>
        /// <param name="clientGroupInfo"> The information of AAD security group. </param>
        /// <param name="configurationOverride"> The configurations that need to be overriden. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal KafkaRestProperties(ClientGroupInfo clientGroupInfo, IDictionary<string, string> configurationOverride, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ClientGroupInfo = clientGroupInfo;
            ConfigurationOverride = configurationOverride;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The information of AAD security group. </summary>
        public ClientGroupInfo ClientGroupInfo { get; set; }
        /// <summary> The configurations that need to be overriden. </summary>
        public IDictionary<string, string> ConfigurationOverride { get; }
    }
}
