// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HDInsight.Models
{
    /// <summary> Algorithm identifier for encryption, default RSA-OAEP. </summary>
    public readonly partial struct JsonWebKeyEncryptionAlgorithm : IEquatable<JsonWebKeyEncryptionAlgorithm>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="JsonWebKeyEncryptionAlgorithm"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public JsonWebKeyEncryptionAlgorithm(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RsaOaepValue = "RSA-OAEP";
        private const string RsaOaep256Value = "RSA-OAEP-256";
        private const string Rsa15Value = "RSA1_5";

        /// <summary> RSA-OAEP. </summary>
        public static JsonWebKeyEncryptionAlgorithm RsaOaep { get; } = new JsonWebKeyEncryptionAlgorithm(RsaOaepValue);
        /// <summary> RSA-OAEP-256. </summary>
        public static JsonWebKeyEncryptionAlgorithm RsaOaep256 { get; } = new JsonWebKeyEncryptionAlgorithm(RsaOaep256Value);
        /// <summary> RSA1_5. </summary>
        public static JsonWebKeyEncryptionAlgorithm Rsa15 { get; } = new JsonWebKeyEncryptionAlgorithm(Rsa15Value);
        /// <summary> Determines if two <see cref="JsonWebKeyEncryptionAlgorithm"/> values are the same. </summary>
        public static bool operator ==(JsonWebKeyEncryptionAlgorithm left, JsonWebKeyEncryptionAlgorithm right) => left.Equals(right);
        /// <summary> Determines if two <see cref="JsonWebKeyEncryptionAlgorithm"/> values are not the same. </summary>
        public static bool operator !=(JsonWebKeyEncryptionAlgorithm left, JsonWebKeyEncryptionAlgorithm right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="JsonWebKeyEncryptionAlgorithm"/>. </summary>
        public static implicit operator JsonWebKeyEncryptionAlgorithm(string value) => new JsonWebKeyEncryptionAlgorithm(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is JsonWebKeyEncryptionAlgorithm other && Equals(other);
        /// <inheritdoc />
        public bool Equals(JsonWebKeyEncryptionAlgorithm other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
