// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.HDInsight.Models
{
    public partial class HDInsightVmSizeProperty : IUtf8JsonSerializable, IJsonModel<HDInsightVmSizeProperty>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<HDInsightVmSizeProperty>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<HDInsightVmSizeProperty>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HDInsightVmSizeProperty>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(HDInsightVmSizeProperty)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(Name))
            {
                writer.WritePropertyName("name"u8);
                writer.WriteStringValue(Name);
            }
            if (Optional.IsDefined(Cores))
            {
                writer.WritePropertyName("cores"u8);
                writer.WriteNumberValue(Cores.Value);
            }
            if (Optional.IsDefined(DataDiskStorageTier))
            {
                writer.WritePropertyName("dataDiskStorageTier"u8);
                writer.WriteStringValue(DataDiskStorageTier);
            }
            if (Optional.IsDefined(Label))
            {
                writer.WritePropertyName("label"u8);
                writer.WriteStringValue(Label);
            }
            if (Optional.IsDefined(MaxDataDiskCount))
            {
                writer.WritePropertyName("maxDataDiskCount"u8);
                writer.WriteNumberValue(MaxDataDiskCount.Value);
            }
            if (Optional.IsDefined(MemoryInMB))
            {
                writer.WritePropertyName("memoryInMb"u8);
                writer.WriteNumberValue(MemoryInMB.Value);
            }
            if (Optional.IsDefined(IsSupportedByVirtualMachines))
            {
                writer.WritePropertyName("supportedByVirtualMachines"u8);
                writer.WriteBooleanValue(IsSupportedByVirtualMachines.Value);
            }
            if (Optional.IsDefined(IsSupportedByWebWorkerRoles))
            {
                writer.WritePropertyName("supportedByWebWorkerRoles"u8);
                writer.WriteBooleanValue(IsSupportedByWebWorkerRoles.Value);
            }
            if (Optional.IsDefined(VirtualMachineResourceDiskSizeInMB))
            {
                writer.WritePropertyName("virtualMachineResourceDiskSizeInMb"u8);
                writer.WriteNumberValue(VirtualMachineResourceDiskSizeInMB.Value);
            }
            if (Optional.IsDefined(WebWorkerResourceDiskSizeInMB))
            {
                writer.WritePropertyName("webWorkerResourceDiskSizeInMb"u8);
                writer.WriteNumberValue(WebWorkerResourceDiskSizeInMB.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        HDInsightVmSizeProperty IJsonModel<HDInsightVmSizeProperty>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HDInsightVmSizeProperty>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(HDInsightVmSizeProperty)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeHDInsightVmSizeProperty(document.RootElement, options);
        }

        internal static HDInsightVmSizeProperty DeserializeHDInsightVmSizeProperty(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string name = default;
            int? cores = default;
            string dataDiskStorageTier = default;
            string label = default;
            long? maxDataDiskCount = default;
            long? memoryInMB = default;
            bool? supportedByVirtualMachines = default;
            bool? supportedByWebWorkerRoles = default;
            long? virtualMachineResourceDiskSizeInMB = default;
            long? webWorkerResourceDiskSizeInMB = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("cores"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    cores = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("dataDiskStorageTier"u8))
                {
                    dataDiskStorageTier = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("label"u8))
                {
                    label = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("maxDataDiskCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    maxDataDiskCount = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("memoryInMb"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    memoryInMB = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("supportedByVirtualMachines"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    supportedByVirtualMachines = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("supportedByWebWorkerRoles"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    supportedByWebWorkerRoles = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("virtualMachineResourceDiskSizeInMb"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    virtualMachineResourceDiskSizeInMB = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("webWorkerResourceDiskSizeInMb"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    webWorkerResourceDiskSizeInMB = property.Value.GetInt64();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new HDInsightVmSizeProperty(
                name,
                cores,
                dataDiskStorageTier,
                label,
                maxDataDiskCount,
                memoryInMB,
                supportedByVirtualMachines,
                supportedByWebWorkerRoles,
                virtualMachineResourceDiskSizeInMB,
                webWorkerResourceDiskSizeInMB,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<HDInsightVmSizeProperty>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HDInsightVmSizeProperty>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(HDInsightVmSizeProperty)} does not support writing '{options.Format}' format.");
            }
        }

        HDInsightVmSizeProperty IPersistableModel<HDInsightVmSizeProperty>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HDInsightVmSizeProperty>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeHDInsightVmSizeProperty(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(HDInsightVmSizeProperty)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<HDInsightVmSizeProperty>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
