// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HDInsight.Models
{
    /// <summary> The concrete private link service connection. </summary>
    public readonly partial struct HDInsightPrivateLinkServiceConnectionStatus : IEquatable<HDInsightPrivateLinkServiceConnectionStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="HDInsightPrivateLinkServiceConnectionStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public HDInsightPrivateLinkServiceConnectionStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ApprovedValue = "Approved";
        private const string RejectedValue = "Rejected";
        private const string PendingValue = "Pending";
        private const string RemovedValue = "Removed";

        /// <summary> Approved. </summary>
        public static HDInsightPrivateLinkServiceConnectionStatus Approved { get; } = new HDInsightPrivateLinkServiceConnectionStatus(ApprovedValue);
        /// <summary> Rejected. </summary>
        public static HDInsightPrivateLinkServiceConnectionStatus Rejected { get; } = new HDInsightPrivateLinkServiceConnectionStatus(RejectedValue);
        /// <summary> Pending. </summary>
        public static HDInsightPrivateLinkServiceConnectionStatus Pending { get; } = new HDInsightPrivateLinkServiceConnectionStatus(PendingValue);
        /// <summary> Removed. </summary>
        public static HDInsightPrivateLinkServiceConnectionStatus Removed { get; } = new HDInsightPrivateLinkServiceConnectionStatus(RemovedValue);
        /// <summary> Determines if two <see cref="HDInsightPrivateLinkServiceConnectionStatus"/> values are the same. </summary>
        public static bool operator ==(HDInsightPrivateLinkServiceConnectionStatus left, HDInsightPrivateLinkServiceConnectionStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HDInsightPrivateLinkServiceConnectionStatus"/> values are not the same. </summary>
        public static bool operator !=(HDInsightPrivateLinkServiceConnectionStatus left, HDInsightPrivateLinkServiceConnectionStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="HDInsightPrivateLinkServiceConnectionStatus"/>. </summary>
        public static implicit operator HDInsightPrivateLinkServiceConnectionStatus(string value) => new HDInsightPrivateLinkServiceConnectionStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HDInsightPrivateLinkServiceConnectionStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HDInsightPrivateLinkServiceConnectionStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
