// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HDInsight.Models
{
    /// <summary> The ssh username, password, and ssh public key. </summary>
    public partial class HDInsightLinuxOSProfile
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HDInsightLinuxOSProfile"/>. </summary>
        public HDInsightLinuxOSProfile()
        {
        }

        /// <summary> Initializes a new instance of <see cref="HDInsightLinuxOSProfile"/>. </summary>
        /// <param name="username"> The username. </param>
        /// <param name="password"> The password. </param>
        /// <param name="sshProfile"> The SSH profile. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HDInsightLinuxOSProfile(string username, string password, SshProfile sshProfile, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Username = username;
            Password = password;
            SshProfile = sshProfile;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The username. </summary>
        public string Username { get; set; }
        /// <summary> The password. </summary>
        public string Password { get; set; }
        /// <summary> The SSH profile. </summary>
        internal SshProfile SshProfile { get; set; }
        /// <summary> The list of SSH public keys. </summary>
        public IList<HDInsightSshPublicKey> SshPublicKeys
        {
            get
            {
                if (SshProfile is null)
                    SshProfile = new SshProfile();
                return SshProfile.PublicKeys;
            }
        }
    }
}
