// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.HDInsight.Models
{
    /// <summary> The disk encryption properties. </summary>
    public partial class HDInsightDiskEncryptionProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HDInsightDiskEncryptionProperties"/>. </summary>
        public HDInsightDiskEncryptionProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="HDInsightDiskEncryptionProperties"/>. </summary>
        /// <param name="vaultUri"> Base key vault URI where the customers key is located eg. https://myvault.vault.azure.net. </param>
        /// <param name="keyName"> Key name that is used for enabling disk encryption. </param>
        /// <param name="keyVersion"> Specific key version that is used for enabling disk encryption. </param>
        /// <param name="encryptionAlgorithm"> Algorithm identifier for encryption, default RSA-OAEP. </param>
        /// <param name="msiResourceId"> Resource ID of Managed Identity that is used to access the key vault. </param>
        /// <param name="isEncryptionAtHostEnabled"> Indicates whether or not resource disk encryption is enabled. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HDInsightDiskEncryptionProperties(Uri vaultUri, string keyName, string keyVersion, JsonWebKeyEncryptionAlgorithm? encryptionAlgorithm, ResourceIdentifier msiResourceId, bool? isEncryptionAtHostEnabled, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            VaultUri = vaultUri;
            KeyName = keyName;
            KeyVersion = keyVersion;
            EncryptionAlgorithm = encryptionAlgorithm;
            MsiResourceId = msiResourceId;
            IsEncryptionAtHostEnabled = isEncryptionAtHostEnabled;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Base key vault URI where the customers key is located eg. https://myvault.vault.azure.net. </summary>
        public Uri VaultUri { get; set; }
        /// <summary> Key name that is used for enabling disk encryption. </summary>
        public string KeyName { get; set; }
        /// <summary> Specific key version that is used for enabling disk encryption. </summary>
        public string KeyVersion { get; set; }
        /// <summary> Algorithm identifier for encryption, default RSA-OAEP. </summary>
        public JsonWebKeyEncryptionAlgorithm? EncryptionAlgorithm { get; set; }
        /// <summary> Resource ID of Managed Identity that is used to access the key vault. </summary>
        public ResourceIdentifier MsiResourceId { get; set; }
        /// <summary> Indicates whether or not resource disk encryption is enabled. </summary>
        public bool? IsEncryptionAtHostEnabled { get; set; }
    }
}
