// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.HDInsight.Models
{
    public partial class HDInsightDiskEncryptionProperties : IUtf8JsonSerializable, IJsonModel<HDInsightDiskEncryptionProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<HDInsightDiskEncryptionProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<HDInsightDiskEncryptionProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HDInsightDiskEncryptionProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(HDInsightDiskEncryptionProperties)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(VaultUri))
            {
                writer.WritePropertyName("vaultUri"u8);
                writer.WriteStringValue(VaultUri.AbsoluteUri);
            }
            if (Optional.IsDefined(KeyName))
            {
                writer.WritePropertyName("keyName"u8);
                writer.WriteStringValue(KeyName);
            }
            if (Optional.IsDefined(KeyVersion))
            {
                writer.WritePropertyName("keyVersion"u8);
                writer.WriteStringValue(KeyVersion);
            }
            if (Optional.IsDefined(EncryptionAlgorithm))
            {
                if (EncryptionAlgorithm != null)
                {
                    writer.WritePropertyName("encryptionAlgorithm"u8);
                    writer.WriteStringValue(EncryptionAlgorithm.Value.ToString());
                }
                else
                {
                    writer.WriteNull("encryptionAlgorithm");
                }
            }
            if (Optional.IsDefined(MsiResourceId))
            {
                if (MsiResourceId != null)
                {
                    writer.WritePropertyName("msiResourceId"u8);
                    writer.WriteStringValue(MsiResourceId);
                }
                else
                {
                    writer.WriteNull("msiResourceId");
                }
            }
            if (Optional.IsDefined(IsEncryptionAtHostEnabled))
            {
                writer.WritePropertyName("encryptionAtHost"u8);
                writer.WriteBooleanValue(IsEncryptionAtHostEnabled.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        HDInsightDiskEncryptionProperties IJsonModel<HDInsightDiskEncryptionProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HDInsightDiskEncryptionProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(HDInsightDiskEncryptionProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeHDInsightDiskEncryptionProperties(document.RootElement, options);
        }

        internal static HDInsightDiskEncryptionProperties DeserializeHDInsightDiskEncryptionProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            Uri vaultUri = default;
            string keyName = default;
            string keyVersion = default;
            JsonWebKeyEncryptionAlgorithm? encryptionAlgorithm = default;
            ResourceIdentifier msiResourceId = default;
            bool? encryptionAtHost = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("vaultUri"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    vaultUri = new Uri(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("keyName"u8))
                {
                    keyName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("keyVersion"u8))
                {
                    keyVersion = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("encryptionAlgorithm"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        encryptionAlgorithm = null;
                        continue;
                    }
                    encryptionAlgorithm = new JsonWebKeyEncryptionAlgorithm(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("msiResourceId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        msiResourceId = null;
                        continue;
                    }
                    msiResourceId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("encryptionAtHost"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    encryptionAtHost = property.Value.GetBoolean();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new HDInsightDiskEncryptionProperties(
                vaultUri,
                keyName,
                keyVersion,
                encryptionAlgorithm,
                msiResourceId,
                encryptionAtHost,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<HDInsightDiskEncryptionProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HDInsightDiskEncryptionProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(HDInsightDiskEncryptionProperties)} does not support writing '{options.Format}' format.");
            }
        }

        HDInsightDiskEncryptionProperties IPersistableModel<HDInsightDiskEncryptionProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HDInsightDiskEncryptionProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeHDInsightDiskEncryptionProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(HDInsightDiskEncryptionProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<HDInsightDiskEncryptionProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
