// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HDInsight.Models
{
    /// <summary> The HDInsightDayOfWeek. </summary>
    public readonly partial struct HDInsightDayOfWeek : IEquatable<HDInsightDayOfWeek>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="HDInsightDayOfWeek"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public HDInsightDayOfWeek(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MondayValue = "Monday";
        private const string TuesdayValue = "Tuesday";
        private const string WednesdayValue = "Wednesday";
        private const string ThursdayValue = "Thursday";
        private const string FridayValue = "Friday";
        private const string SaturdayValue = "Saturday";
        private const string SundayValue = "Sunday";

        /// <summary> Monday. </summary>
        public static HDInsightDayOfWeek Monday { get; } = new HDInsightDayOfWeek(MondayValue);
        /// <summary> Tuesday. </summary>
        public static HDInsightDayOfWeek Tuesday { get; } = new HDInsightDayOfWeek(TuesdayValue);
        /// <summary> Wednesday. </summary>
        public static HDInsightDayOfWeek Wednesday { get; } = new HDInsightDayOfWeek(WednesdayValue);
        /// <summary> Thursday. </summary>
        public static HDInsightDayOfWeek Thursday { get; } = new HDInsightDayOfWeek(ThursdayValue);
        /// <summary> Friday. </summary>
        public static HDInsightDayOfWeek Friday { get; } = new HDInsightDayOfWeek(FridayValue);
        /// <summary> Saturday. </summary>
        public static HDInsightDayOfWeek Saturday { get; } = new HDInsightDayOfWeek(SaturdayValue);
        /// <summary> Sunday. </summary>
        public static HDInsightDayOfWeek Sunday { get; } = new HDInsightDayOfWeek(SundayValue);
        /// <summary> Determines if two <see cref="HDInsightDayOfWeek"/> values are the same. </summary>
        public static bool operator ==(HDInsightDayOfWeek left, HDInsightDayOfWeek right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HDInsightDayOfWeek"/> values are not the same. </summary>
        public static bool operator !=(HDInsightDayOfWeek left, HDInsightDayOfWeek right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="HDInsightDayOfWeek"/>. </summary>
        public static implicit operator HDInsightDayOfWeek(string value) => new HDInsightDayOfWeek(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HDInsightDayOfWeek other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HDInsightDayOfWeek other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
