// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.HDInsight.Models
{
    public partial class HDInsightComputeIsolationProperties : IUtf8JsonSerializable, IJsonModel<HDInsightComputeIsolationProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<HDInsightComputeIsolationProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<HDInsightComputeIsolationProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HDInsightComputeIsolationProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(HDInsightComputeIsolationProperties)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(EnableComputeIsolation))
            {
                writer.WritePropertyName("enableComputeIsolation"u8);
                writer.WriteBooleanValue(EnableComputeIsolation.Value);
            }
            if (Optional.IsDefined(HostSku))
            {
                writer.WritePropertyName("hostSku"u8);
                writer.WriteStringValue(HostSku);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        HDInsightComputeIsolationProperties IJsonModel<HDInsightComputeIsolationProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HDInsightComputeIsolationProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(HDInsightComputeIsolationProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeHDInsightComputeIsolationProperties(document.RootElement, options);
        }

        internal static HDInsightComputeIsolationProperties DeserializeHDInsightComputeIsolationProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            bool? enableComputeIsolation = default;
            string hostSku = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("enableComputeIsolation"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    enableComputeIsolation = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("hostSku"u8))
                {
                    hostSku = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new HDInsightComputeIsolationProperties(enableComputeIsolation, hostSku, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<HDInsightComputeIsolationProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HDInsightComputeIsolationProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(HDInsightComputeIsolationProperties)} does not support writing '{options.Format}' format.");
            }
        }

        HDInsightComputeIsolationProperties IPersistableModel<HDInsightComputeIsolationProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HDInsightComputeIsolationProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeHDInsightComputeIsolationProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(HDInsightComputeIsolationProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<HDInsightComputeIsolationProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
