// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HDInsight.Models
{
    /// <summary> The provisioning state, which only appears in the response. </summary>
    public readonly partial struct HDInsightClusterProvisioningState : IEquatable<HDInsightClusterProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="HDInsightClusterProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public HDInsightClusterProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InProgressValue = "InProgress";
        private const string FailedValue = "Failed";
        private const string SucceededValue = "Succeeded";
        private const string CanceledValue = "Canceled";
        private const string DeletingValue = "Deleting";

        /// <summary> InProgress. </summary>
        public static HDInsightClusterProvisioningState InProgress { get; } = new HDInsightClusterProvisioningState(InProgressValue);
        /// <summary> Failed. </summary>
        public static HDInsightClusterProvisioningState Failed { get; } = new HDInsightClusterProvisioningState(FailedValue);
        /// <summary> Succeeded. </summary>
        public static HDInsightClusterProvisioningState Succeeded { get; } = new HDInsightClusterProvisioningState(SucceededValue);
        /// <summary> Canceled. </summary>
        public static HDInsightClusterProvisioningState Canceled { get; } = new HDInsightClusterProvisioningState(CanceledValue);
        /// <summary> Deleting. </summary>
        public static HDInsightClusterProvisioningState Deleting { get; } = new HDInsightClusterProvisioningState(DeletingValue);
        /// <summary> Determines if two <see cref="HDInsightClusterProvisioningState"/> values are the same. </summary>
        public static bool operator ==(HDInsightClusterProvisioningState left, HDInsightClusterProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HDInsightClusterProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(HDInsightClusterProvisioningState left, HDInsightClusterProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="HDInsightClusterProvisioningState"/>. </summary>
        public static implicit operator HDInsightClusterProvisioningState(string value) => new HDInsightClusterProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HDInsightClusterProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HDInsightClusterProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
