// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HDInsight.Models
{
    /// <summary> Contains the IpTag associated with the public IP address. </summary>
    public partial class HDInsightClusterIPTag
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HDInsightClusterIPTag"/>. </summary>
        /// <param name="ipTagType"> Gets or sets the ipTag type: Example FirstPartyUsage. </param>
        /// <param name="tag"> Gets or sets value of the IpTag associated with the public IP. Example HDInsight, SQL, Storage etc. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="ipTagType"/> or <paramref name="tag"/> is null. </exception>
        public HDInsightClusterIPTag(string ipTagType, string tag)
        {
            Argument.AssertNotNull(ipTagType, nameof(ipTagType));
            Argument.AssertNotNull(tag, nameof(tag));

            IPTagType = ipTagType;
            Tag = tag;
        }

        /// <summary> Initializes a new instance of <see cref="HDInsightClusterIPTag"/>. </summary>
        /// <param name="ipTagType"> Gets or sets the ipTag type: Example FirstPartyUsage. </param>
        /// <param name="tag"> Gets or sets value of the IpTag associated with the public IP. Example HDInsight, SQL, Storage etc. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HDInsightClusterIPTag(string ipTagType, string tag, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            IPTagType = ipTagType;
            Tag = tag;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="HDInsightClusterIPTag"/> for deserialization. </summary>
        internal HDInsightClusterIPTag()
        {
        }

        /// <summary> Gets or sets the ipTag type: Example FirstPartyUsage. </summary>
        public string IPTagType { get; set; }
        /// <summary> Gets or sets value of the IpTag associated with the public IP. Example HDInsight, SQL, Storage etc. </summary>
        public string Tag { get; set; }
    }
}
