// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HDInsight.Models
{
    /// <summary> The data disks groups for the role. </summary>
    public partial class HDInsightClusterDataDiskGroup
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HDInsightClusterDataDiskGroup"/>. </summary>
        public HDInsightClusterDataDiskGroup()
        {
        }

        /// <summary> Initializes a new instance of <see cref="HDInsightClusterDataDiskGroup"/>. </summary>
        /// <param name="disksPerNode"> The number of disks per node. </param>
        /// <param name="storageAccountType"> ReadOnly. The storage account type. Do not set this value. </param>
        /// <param name="diskSizeInGB"> ReadOnly. The DiskSize in GB. Do not set this value. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HDInsightClusterDataDiskGroup(int? disksPerNode, string storageAccountType, int? diskSizeInGB, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DisksPerNode = disksPerNode;
            StorageAccountType = storageAccountType;
            DiskSizeInGB = diskSizeInGB;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The number of disks per node. </summary>
        public int? DisksPerNode { get; set; }
        /// <summary> ReadOnly. The storage account type. Do not set this value. </summary>
        public string StorageAccountType { get; }
        /// <summary> ReadOnly. The DiskSize in GB. Do not set this value. </summary>
        public int? DiskSizeInGB { get; }
    }
}
