// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HDInsight.Models
{
    /// <summary> Cluster monitoring extensions. </summary>
    public partial class HDInsightClusterCreateExtensionContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HDInsightClusterCreateExtensionContent"/>. </summary>
        public HDInsightClusterCreateExtensionContent()
        {
        }

        /// <summary> Initializes a new instance of <see cref="HDInsightClusterCreateExtensionContent"/>. </summary>
        /// <param name="workspaceId"> The workspace ID for the cluster monitoring extension. </param>
        /// <param name="primaryKey"> The certificate for the cluster monitoring extensions. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HDInsightClusterCreateExtensionContent(string workspaceId, string primaryKey, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            WorkspaceId = workspaceId;
            PrimaryKey = primaryKey;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The workspace ID for the cluster monitoring extension. </summary>
        public string WorkspaceId { get; set; }
        /// <summary> The certificate for the cluster monitoring extensions. </summary>
        public string PrimaryKey { get; set; }
    }
}
