// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.HDInsight.Models
{
    /// <summary> The Azure active directory domain service resource details. </summary>
    public partial class HDInsightClusterAaddsDetail
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HDInsightClusterAaddsDetail"/>. </summary>
        internal HDInsightClusterAaddsDetail()
        {
        }

        /// <summary> Initializes a new instance of <see cref="HDInsightClusterAaddsDetail"/>. </summary>
        /// <param name="domainName"> The Azure active directory domain service name. </param>
        /// <param name="isInitialSyncComplete"> This indicates whether initial sync complete or not. </param>
        /// <param name="isLdapsEnabled"> This indicates whether enable ldaps or not. </param>
        /// <param name="ldapsPublicCertificateInBase64"> The base 64 format string of public ldap certificate. </param>
        /// <param name="resourceId"> The resource id of azure active directory domain service. </param>
        /// <param name="subnetId"> The subnet resource id. </param>
        /// <param name="tenantId"> The tenant id of azure active directory domain service . </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HDInsightClusterAaddsDetail(string domainName, bool? isInitialSyncComplete, bool? isLdapsEnabled, string ldapsPublicCertificateInBase64, ResourceIdentifier resourceId, ResourceIdentifier subnetId, Guid? tenantId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DomainName = domainName;
            IsInitialSyncComplete = isInitialSyncComplete;
            IsLdapsEnabled = isLdapsEnabled;
            LdapsPublicCertificateInBase64 = ldapsPublicCertificateInBase64;
            ResourceId = resourceId;
            SubnetId = subnetId;
            TenantId = tenantId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The Azure active directory domain service name. </summary>
        public string DomainName { get; }
        /// <summary> This indicates whether initial sync complete or not. </summary>
        public bool? IsInitialSyncComplete { get; }
        /// <summary> This indicates whether enable ldaps or not. </summary>
        public bool? IsLdapsEnabled { get; }
        /// <summary> The base 64 format string of public ldap certificate. </summary>
        public string LdapsPublicCertificateInBase64 { get; }
        /// <summary> The resource id of azure active directory domain service. </summary>
        public ResourceIdentifier ResourceId { get; }
        /// <summary> The subnet resource id. </summary>
        public ResourceIdentifier SubnetId { get; }
        /// <summary> The tenant id of azure active directory domain service . </summary>
        public Guid? TenantId { get; }
    }
}
