// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.HDInsight.Models
{
    public partial class HDInsightBillingSpecsListResult : IUtf8JsonSerializable, IJsonModel<HDInsightBillingSpecsListResult>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<HDInsightBillingSpecsListResult>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<HDInsightBillingSpecsListResult>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HDInsightBillingSpecsListResult>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(HDInsightBillingSpecsListResult)} does not support writing '{format}' format.");
            }

            if (Optional.IsCollectionDefined(VmSizes))
            {
                writer.WritePropertyName("vmSizes"u8);
                writer.WriteStartArray();
                foreach (var item in VmSizes)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(VmSizesWithEncryptionAtHost))
            {
                writer.WritePropertyName("vmSizesWithEncryptionAtHost"u8);
                writer.WriteStartArray();
                foreach (var item in VmSizesWithEncryptionAtHost)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(VmSizeFilters))
            {
                writer.WritePropertyName("vmSizeFilters"u8);
                writer.WriteStartArray();
                foreach (var item in VmSizeFilters)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(VmSizeProperties))
            {
                writer.WritePropertyName("vmSizeProperties"u8);
                writer.WriteStartArray();
                foreach (var item in VmSizeProperties)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(BillingResources))
            {
                writer.WritePropertyName("billingResources"u8);
                writer.WriteStartArray();
                foreach (var item in BillingResources)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        HDInsightBillingSpecsListResult IJsonModel<HDInsightBillingSpecsListResult>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HDInsightBillingSpecsListResult>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(HDInsightBillingSpecsListResult)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeHDInsightBillingSpecsListResult(document.RootElement, options);
        }

        internal static HDInsightBillingSpecsListResult DeserializeHDInsightBillingSpecsListResult(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IReadOnlyList<string> vmSizes = default;
            IReadOnlyList<string> vmSizesWithEncryptionAtHost = default;
            IReadOnlyList<HDInsightVmSizeCompatibilityFilterV2> vmSizeFilters = default;
            IReadOnlyList<HDInsightVmSizeProperty> vmSizeProperties = default;
            IReadOnlyList<HDInsightBillingResources> billingResources = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("vmSizes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    vmSizes = array;
                    continue;
                }
                if (property.NameEquals("vmSizesWithEncryptionAtHost"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    vmSizesWithEncryptionAtHost = array;
                    continue;
                }
                if (property.NameEquals("vmSizeFilters"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<HDInsightVmSizeCompatibilityFilterV2> array = new List<HDInsightVmSizeCompatibilityFilterV2>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(HDInsightVmSizeCompatibilityFilterV2.DeserializeHDInsightVmSizeCompatibilityFilterV2(item, options));
                    }
                    vmSizeFilters = array;
                    continue;
                }
                if (property.NameEquals("vmSizeProperties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<HDInsightVmSizeProperty> array = new List<HDInsightVmSizeProperty>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(HDInsightVmSizeProperty.DeserializeHDInsightVmSizeProperty(item, options));
                    }
                    vmSizeProperties = array;
                    continue;
                }
                if (property.NameEquals("billingResources"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<HDInsightBillingResources> array = new List<HDInsightBillingResources>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(HDInsightBillingResources.DeserializeHDInsightBillingResources(item, options));
                    }
                    billingResources = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new HDInsightBillingSpecsListResult(
                vmSizes ?? new ChangeTrackingList<string>(),
                vmSizesWithEncryptionAtHost ?? new ChangeTrackingList<string>(),
                vmSizeFilters ?? new ChangeTrackingList<HDInsightVmSizeCompatibilityFilterV2>(),
                vmSizeProperties ?? new ChangeTrackingList<HDInsightVmSizeProperty>(),
                billingResources ?? new ChangeTrackingList<HDInsightBillingResources>(),
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<HDInsightBillingSpecsListResult>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HDInsightBillingSpecsListResult>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(HDInsightBillingSpecsListResult)} does not support writing '{options.Format}' format.");
            }
        }

        HDInsightBillingSpecsListResult IPersistableModel<HDInsightBillingSpecsListResult>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HDInsightBillingSpecsListResult>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeHDInsightBillingSpecsListResult(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(HDInsightBillingSpecsListResult)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<HDInsightBillingSpecsListResult>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
