// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.HDInsight.Models
{
    /// <summary> The billing resources. </summary>
    public partial class HDInsightBillingResources
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HDInsightBillingResources"/>. </summary>
        internal HDInsightBillingResources()
        {
            BillingMeters = new ChangeTrackingList<HDInsightBillingMeters>();
            DiskBillingMeters = new ChangeTrackingList<HDInsightDiskBillingMeters>();
        }

        /// <summary> Initializes a new instance of <see cref="HDInsightBillingResources"/>. </summary>
        /// <param name="region"> The region or location. </param>
        /// <param name="billingMeters"> The billing meter information. </param>
        /// <param name="diskBillingMeters"> The managed disk billing information. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HDInsightBillingResources(AzureLocation? region, IReadOnlyList<HDInsightBillingMeters> billingMeters, IReadOnlyList<HDInsightDiskBillingMeters> diskBillingMeters, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Region = region;
            BillingMeters = billingMeters;
            DiskBillingMeters = diskBillingMeters;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The region or location. </summary>
        public AzureLocation? Region { get; }
        /// <summary> The billing meter information. </summary>
        public IReadOnlyList<HDInsightBillingMeters> BillingMeters { get; }
        /// <summary> The managed disk billing information. </summary>
        public IReadOnlyList<HDInsightDiskBillingMeters> DiskBillingMeters { get; }
    }
}
