// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HDInsight.Models
{
    /// <summary> The azure monitor parameters. </summary>
    public partial class HDInsightAzureMonitorExtensionEnableContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HDInsightAzureMonitorExtensionEnableContent"/>. </summary>
        public HDInsightAzureMonitorExtensionEnableContent()
        {
        }

        /// <summary> Initializes a new instance of <see cref="HDInsightAzureMonitorExtensionEnableContent"/>. </summary>
        /// <param name="workspaceId"> The Log Analytics workspace ID. </param>
        /// <param name="primaryKey"> The Log Analytics workspace key. </param>
        /// <param name="selectedConfigurations"> The selected configurations. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HDInsightAzureMonitorExtensionEnableContent(string workspaceId, string primaryKey, HDInsightAzureMonitorSelectedConfigurations selectedConfigurations, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            WorkspaceId = workspaceId;
            PrimaryKey = primaryKey;
            SelectedConfigurations = selectedConfigurations;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The Log Analytics workspace ID. </summary>
        public string WorkspaceId { get; set; }
        /// <summary> The Log Analytics workspace key. </summary>
        public string PrimaryKey { get; set; }
        /// <summary> The selected configurations. </summary>
        public HDInsightAzureMonitorSelectedConfigurations SelectedConfigurations { get; set; }
    }
}
