// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HDInsight.Models
{
    /// <summary> The information of AAD security group. </summary>
    public partial class ClientGroupInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ClientGroupInfo"/>. </summary>
        public ClientGroupInfo()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ClientGroupInfo"/>. </summary>
        /// <param name="groupName"> The AAD security group name. </param>
        /// <param name="groupId"> The AAD security group id. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ClientGroupInfo(string groupName, string groupId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            GroupName = groupName;
            GroupId = groupId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The AAD security group name. </summary>
        public string GroupName { get; set; }
        /// <summary> The AAD security group id. </summary>
        public string GroupId { get; set; }
    }
}
