// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HDInsight.Models
{
    /// <summary> The directory type. </summary>
    public readonly partial struct AuthenticationDirectoryType : IEquatable<AuthenticationDirectoryType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AuthenticationDirectoryType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AuthenticationDirectoryType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ActiveDirectoryValue = "ActiveDirectory";

        /// <summary> ActiveDirectory. </summary>
        public static AuthenticationDirectoryType ActiveDirectory { get; } = new AuthenticationDirectoryType(ActiveDirectoryValue);
        /// <summary> Determines if two <see cref="AuthenticationDirectoryType"/> values are the same. </summary>
        public static bool operator ==(AuthenticationDirectoryType left, AuthenticationDirectoryType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AuthenticationDirectoryType"/> values are not the same. </summary>
        public static bool operator !=(AuthenticationDirectoryType left, AuthenticationDirectoryType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AuthenticationDirectoryType"/>. </summary>
        public static implicit operator AuthenticationDirectoryType(string value) => new AuthenticationDirectoryType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AuthenticationDirectoryType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AuthenticationDirectoryType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
