// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.HDInsight
{
    internal class HDInsightApplicationOperationSource : IOperationSource<HDInsightApplicationResource>
    {
        private readonly ArmClient _client;

        internal HDInsightApplicationOperationSource(ArmClient client)
        {
            _client = client;
        }

        HDInsightApplicationResource IOperationSource<HDInsightApplicationResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = HDInsightApplicationData.DeserializeHDInsightApplicationData(document.RootElement);
            return new HDInsightApplicationResource(_client, data);
        }

        async ValueTask<HDInsightApplicationResource> IOperationSource<HDInsightApplicationResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = HDInsightApplicationData.DeserializeHDInsightApplicationData(document.RootElement);
            return new HDInsightApplicationResource(_client, data);
        }
    }
}
