// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.HDInsight.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableHDInsightArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableHDInsightArmClient"/> class for mocking. </summary>
        protected MockableHDInsightArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableHDInsightArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableHDInsightArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableHDInsightArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing a <see cref="HDInsightApplicationResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="HDInsightApplicationResource.CreateResourceIdentifier" /> to create a <see cref="HDInsightApplicationResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="HDInsightApplicationResource"/> object. </returns>
        public virtual HDInsightApplicationResource GetHDInsightApplicationResource(ResourceIdentifier id)
        {
            HDInsightApplicationResource.ValidateResourceId(id);
            return new HDInsightApplicationResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="HDInsightClusterResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="HDInsightClusterResource.CreateResourceIdentifier" /> to create a <see cref="HDInsightClusterResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="HDInsightClusterResource"/> object. </returns>
        public virtual HDInsightClusterResource GetHDInsightClusterResource(ResourceIdentifier id)
        {
            HDInsightClusterResource.ValidateResourceId(id);
            return new HDInsightClusterResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="HDInsightPrivateEndpointConnectionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="HDInsightPrivateEndpointConnectionResource.CreateResourceIdentifier" /> to create a <see cref="HDInsightPrivateEndpointConnectionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="HDInsightPrivateEndpointConnectionResource"/> object. </returns>
        public virtual HDInsightPrivateEndpointConnectionResource GetHDInsightPrivateEndpointConnectionResource(ResourceIdentifier id)
        {
            HDInsightPrivateEndpointConnectionResource.ValidateResourceId(id);
            return new HDInsightPrivateEndpointConnectionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="HDInsightPrivateLinkResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="HDInsightPrivateLinkResource.CreateResourceIdentifier" /> to create a <see cref="HDInsightPrivateLinkResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="HDInsightPrivateLinkResource"/> object. </returns>
        public virtual HDInsightPrivateLinkResource GetHDInsightPrivateLinkResource(ResourceIdentifier id)
        {
            HDInsightPrivateLinkResource.ValidateResourceId(id);
            return new HDInsightPrivateLinkResource(Client, id);
        }
    }
}
