// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.HDInsight.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmHDInsightModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="HDInsight.HDInsightApplicationData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="etag"> The ETag for the application. </param>
        /// <param name="tags"> The tags for the application. </param>
        /// <param name="properties"> The properties of the application. </param>
        /// <returns> A new <see cref="HDInsight.HDInsightApplicationData"/> instance for mocking. </returns>
        public static HDInsightApplicationData HDInsightApplicationData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ETag? etag = null, IDictionary<string, string> tags = null, HDInsightApplicationProperties properties = null)
        {
            tags ??= new Dictionary<string, string>();

            return new HDInsightApplicationData(
                id,
                name,
                resourceType,
                systemData,
                etag,
                tags,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HDInsightApplicationProperties"/>. </summary>
        /// <param name="computeRoles"> The list of roles in the cluster. </param>
        /// <param name="installScriptActions"> The list of install script actions. </param>
        /// <param name="uninstallScriptActions"> The list of uninstall script actions. </param>
        /// <param name="httpsEndpoints"> The list of application HTTPS endpoints. </param>
        /// <param name="sshEndpoints"> The list of application SSH endpoints. </param>
        /// <param name="provisioningState"> The provisioning state of the application. </param>
        /// <param name="applicationType"> The application type. </param>
        /// <param name="applicationState"> The application state. </param>
        /// <param name="errors"> The list of errors. </param>
        /// <param name="createdOn"> The application create date time. </param>
        /// <param name="marketplaceIdentifier"> The marketplace identifier. </param>
        /// <param name="privateLinkConfigurations"> The private link configurations. </param>
        /// <returns> A new <see cref="Models.HDInsightApplicationProperties"/> instance for mocking. </returns>
        public static HDInsightApplicationProperties HDInsightApplicationProperties(IEnumerable<HDInsightClusterRole> computeRoles = null, IEnumerable<RuntimeScriptAction> installScriptActions = null, IEnumerable<RuntimeScriptAction> uninstallScriptActions = null, IEnumerable<HDInsightApplicationHttpsEndpoint> httpsEndpoints = null, IEnumerable<HDInsightApplicationEndpoint> sshEndpoints = null, string provisioningState = null, string applicationType = null, string applicationState = null, IEnumerable<ResponseError> errors = null, DateTimeOffset? createdOn = null, string marketplaceIdentifier = null, IEnumerable<HDInsightPrivateLinkConfiguration> privateLinkConfigurations = null)
        {
            computeRoles ??= new List<HDInsightClusterRole>();
            installScriptActions ??= new List<RuntimeScriptAction>();
            uninstallScriptActions ??= new List<RuntimeScriptAction>();
            httpsEndpoints ??= new List<HDInsightApplicationHttpsEndpoint>();
            sshEndpoints ??= new List<HDInsightApplicationEndpoint>();
            errors ??= new List<ResponseError>();
            privateLinkConfigurations ??= new List<HDInsightPrivateLinkConfiguration>();

            return new HDInsightApplicationProperties(
                computeRoles != null ? new ComputeProfile(computeRoles?.ToList(), serializedAdditionalRawData: null) : null,
                installScriptActions?.ToList(),
                uninstallScriptActions?.ToList(),
                httpsEndpoints?.ToList(),
                sshEndpoints?.ToList(),
                provisioningState,
                applicationType,
                applicationState,
                errors?.ToList(),
                createdOn,
                marketplaceIdentifier,
                privateLinkConfigurations?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HDInsightClusterDataDiskGroup"/>. </summary>
        /// <param name="disksPerNode"> The number of disks per node. </param>
        /// <param name="storageAccountType"> ReadOnly. The storage account type. Do not set this value. </param>
        /// <param name="diskSizeInGB"> ReadOnly. The DiskSize in GB. Do not set this value. </param>
        /// <returns> A new <see cref="Models.HDInsightClusterDataDiskGroup"/> instance for mocking. </returns>
        public static HDInsightClusterDataDiskGroup HDInsightClusterDataDiskGroup(int? disksPerNode = null, string storageAccountType = null, int? diskSizeInGB = null)
        {
            return new HDInsightClusterDataDiskGroup(disksPerNode, storageAccountType, diskSizeInGB, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RuntimeScriptAction"/>. </summary>
        /// <param name="name"> The name of the script action. </param>
        /// <param name="uri"> The URI to the script. </param>
        /// <param name="parameters"> The parameters for the script. </param>
        /// <param name="roles"> The list of roles where script will be executed. </param>
        /// <param name="applicationName"> The application name of the script action, if any. </param>
        /// <returns> A new <see cref="Models.RuntimeScriptAction"/> instance for mocking. </returns>
        public static RuntimeScriptAction RuntimeScriptAction(string name = null, Uri uri = null, string parameters = null, IEnumerable<string> roles = null, string applicationName = null)
        {
            roles ??= new List<string>();

            return new RuntimeScriptAction(
                name,
                uri,
                parameters,
                roles?.ToList(),
                applicationName,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HDInsightApplicationHttpsEndpoint"/>. </summary>
        /// <param name="accessModes"> The list of access modes for the application. </param>
        /// <param name="endpointLocation"> The location of the endpoint. </param>
        /// <param name="destinationPort"> The destination port to connect to. </param>
        /// <param name="publicPort"> The public port to connect to. </param>
        /// <param name="privateIPAddress"> The private ip address of the endpoint. </param>
        /// <param name="subDomainSuffix"> The subdomain suffix of the application. </param>
        /// <param name="disableGatewayAuth"> The value indicates whether to disable GatewayAuth. </param>
        /// <returns> A new <see cref="Models.HDInsightApplicationHttpsEndpoint"/> instance for mocking. </returns>
        public static HDInsightApplicationHttpsEndpoint HDInsightApplicationHttpsEndpoint(IEnumerable<string> accessModes = null, string endpointLocation = null, int? destinationPort = null, int? publicPort = null, IPAddress privateIPAddress = null, string subDomainSuffix = null, bool? disableGatewayAuth = null)
        {
            accessModes ??= new List<string>();

            return new HDInsightApplicationHttpsEndpoint(
                accessModes?.ToList(),
                endpointLocation,
                destinationPort,
                publicPort,
                privateIPAddress,
                subDomainSuffix,
                disableGatewayAuth,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HDInsightPrivateLinkConfiguration"/>. </summary>
        /// <param name="id"> The private link configuration id. </param>
        /// <param name="name"> The name of private link configuration. </param>
        /// <param name="resourceType"> The type of the private link configuration. </param>
        /// <param name="groupId"> The HDInsight private linkable sub-resource name to apply the private link configuration to. For example, 'headnode', 'gateway', 'edgenode'. </param>
        /// <param name="provisioningState"> The private link configuration provisioning state, which only appears in the response. </param>
        /// <param name="ipConfigurations"> The IP configurations for the private link service. </param>
        /// <returns> A new <see cref="Models.HDInsightPrivateLinkConfiguration"/> instance for mocking. </returns>
        public static HDInsightPrivateLinkConfiguration HDInsightPrivateLinkConfiguration(string id = null, string name = null, ResourceType? resourceType = null, string groupId = null, HDInsightPrivateLinkConfigurationProvisioningState? provisioningState = null, IEnumerable<HDInsightIPConfiguration> ipConfigurations = null)
        {
            ipConfigurations ??= new List<HDInsightIPConfiguration>();

            return new HDInsightPrivateLinkConfiguration(
                id,
                name,
                resourceType,
                groupId,
                provisioningState,
                ipConfigurations?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HDInsightIPConfiguration"/>. </summary>
        /// <param name="id"> The private link IP configuration id. </param>
        /// <param name="name"> The name of private link IP configuration. </param>
        /// <param name="resourceType"> The type of the private link IP configuration. </param>
        /// <param name="provisioningState"> The private link configuration provisioning state, which only appears in the response. </param>
        /// <param name="isPrimary"> Indicates whether this IP configuration is primary for the corresponding NIC. </param>
        /// <param name="privateIPAddress"> The IP address. </param>
        /// <param name="privateIPAllocationMethod"> The method that private IP address is allocated. </param>
        /// <param name="subnetId"> The subnet resource id. </param>
        /// <returns> A new <see cref="Models.HDInsightIPConfiguration"/> instance for mocking. </returns>
        public static HDInsightIPConfiguration HDInsightIPConfiguration(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, HDInsightPrivateLinkConfigurationProvisioningState? provisioningState = null, bool? isPrimary = null, IPAddress privateIPAddress = null, HDInsightPrivateIPAllocationMethod? privateIPAllocationMethod = null, ResourceIdentifier subnetId = null)
        {
            return new HDInsightIPConfiguration(
                id,
                name,
                resourceType,
                provisioningState,
                isPrimary,
                privateIPAddress,
                privateIPAllocationMethod,
                subnetId != null ? ResourceManagerModelFactory.WritableSubResource(subnetId) : null,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HDInsightAsyncOperationResult"/>. </summary>
        /// <param name="status"> The async operation state. </param>
        /// <param name="error"> The operation error information. </param>
        /// <returns> A new <see cref="Models.HDInsightAsyncOperationResult"/> instance for mocking. </returns>
        public static HDInsightAsyncOperationResult HDInsightAsyncOperationResult(HDInsightAsyncOperationState? status = null, ResponseError error = null)
        {
            return new HDInsightAsyncOperationResult(status, error, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="HDInsight.HDInsightClusterData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="etag"> The ETag for the resource. </param>
        /// <param name="zones"> The availability zones. </param>
        /// <param name="properties"> The properties of the cluster. </param>
        /// <param name="identity"> The identity of the cluster, if configured. </param>
        /// <returns> A new <see cref="HDInsight.HDInsightClusterData"/> instance for mocking. </returns>
        public static HDInsightClusterData HDInsightClusterData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ETag? etag = null, IEnumerable<string> zones = null, HDInsightClusterProperties properties = null, ManagedServiceIdentity identity = null)
        {
            tags ??= new Dictionary<string, string>();
            zones ??= new List<string>();

            return new HDInsightClusterData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                etag,
                zones?.ToList(),
                properties,
                identity,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HDInsightClusterProperties"/>. </summary>
        /// <param name="clusterVersion"> The version of the cluster. </param>
        /// <param name="clusterHdpVersion"> The hdp version of the cluster. </param>
        /// <param name="osType"> The type of operating system. </param>
        /// <param name="tier"> The cluster tier. </param>
        /// <param name="clusterId"> The cluster id. </param>
        /// <param name="clusterDefinition"> The cluster definition. </param>
        /// <param name="kafkaRestProperties"> The cluster kafka rest proxy configuration. </param>
        /// <param name="securityProfile"> The security profile. </param>
        /// <param name="computeRoles"> The compute profile. </param>
        /// <param name="provisioningState"> The provisioning state, which only appears in the response. </param>
        /// <param name="createdOn"> The date on which the cluster was created. </param>
        /// <param name="clusterState"> The state of the cluster. </param>
        /// <param name="quotaInfoCoresUsed"> The quota information. </param>
        /// <param name="errors"> The list of errors. </param>
        /// <param name="connectivityEndpoints"> The list of connectivity endpoints. </param>
        /// <param name="diskEncryptionProperties"> The disk encryption properties. </param>
        /// <param name="isEncryptionInTransitEnabled"> The encryption-in-transit properties. </param>
        /// <param name="storageAccounts"> The storage profile. </param>
        /// <param name="minSupportedTlsVersion"> The minimal supported tls version. </param>
        /// <param name="excludedServicesConfig"> The excluded services config. </param>
        /// <param name="networkProperties"> The network properties. </param>
        /// <param name="computeIsolationProperties"> The compute isolation properties. </param>
        /// <param name="privateLinkConfigurations"> The private link configurations. </param>
        /// <param name="privateEndpointConnections"> The list of private endpoint connections. </param>
        /// <returns> A new <see cref="Models.HDInsightClusterProperties"/> instance for mocking. </returns>
        public static HDInsightClusterProperties HDInsightClusterProperties(string clusterVersion = null, string clusterHdpVersion = null, HDInsightOSType? osType = null, HDInsightTier? tier = null, string clusterId = null, HDInsightClusterDefinition clusterDefinition = null, KafkaRestProperties kafkaRestProperties = null, HDInsightSecurityProfile securityProfile = null, IEnumerable<HDInsightClusterRole> computeRoles = null, HDInsightClusterProvisioningState? provisioningState = null, DateTimeOffset? createdOn = null, string clusterState = null, int? quotaInfoCoresUsed = null, IEnumerable<ResponseError> errors = null, IEnumerable<ConnectivityEndpoint> connectivityEndpoints = null, HDInsightDiskEncryptionProperties diskEncryptionProperties = null, bool? isEncryptionInTransitEnabled = null, IEnumerable<HDInsightStorageAccountInfo> storageAccounts = null, string minSupportedTlsVersion = null, ExcludedServicesConfig excludedServicesConfig = null, HDInsightClusterNetworkProperties networkProperties = null, HDInsightComputeIsolationProperties computeIsolationProperties = null, IEnumerable<HDInsightPrivateLinkConfiguration> privateLinkConfigurations = null, IEnumerable<HDInsightPrivateEndpointConnectionData> privateEndpointConnections = null)
        {
            computeRoles ??= new List<HDInsightClusterRole>();
            errors ??= new List<ResponseError>();
            connectivityEndpoints ??= new List<ConnectivityEndpoint>();
            storageAccounts ??= new List<HDInsightStorageAccountInfo>();
            privateLinkConfigurations ??= new List<HDInsightPrivateLinkConfiguration>();
            privateEndpointConnections ??= new List<HDInsightPrivateEndpointConnectionData>();

            return new HDInsightClusterProperties(
                clusterVersion,
                clusterHdpVersion,
                osType,
                tier,
                clusterId,
                clusterDefinition,
                kafkaRestProperties,
                securityProfile,
                computeRoles != null ? new ComputeProfile(computeRoles?.ToList(), serializedAdditionalRawData: null) : null,
                provisioningState,
                createdOn,
                clusterState,
                quotaInfoCoresUsed != null ? new QuotaInfo(quotaInfoCoresUsed, serializedAdditionalRawData: null) : null,
                errors?.ToList(),
                connectivityEndpoints?.ToList(),
                diskEncryptionProperties,
                isEncryptionInTransitEnabled != null ? new EncryptionInTransitProperties(isEncryptionInTransitEnabled, serializedAdditionalRawData: null) : null,
                storageAccounts != null ? new StorageProfile(storageAccounts?.ToList(), serializedAdditionalRawData: null) : null,
                minSupportedTlsVersion,
                excludedServicesConfig,
                networkProperties,
                computeIsolationProperties,
                privateLinkConfigurations?.ToList(),
                privateEndpointConnections?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="HDInsight.HDInsightPrivateEndpointConnectionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="privateEndpointId"> The private endpoint of the private endpoint connection. </param>
        /// <param name="connectionState"> The private link service connection state. </param>
        /// <param name="linkIdentifier"> The link identifier. </param>
        /// <param name="provisioningState"> The provisioning state, which only appears in the response. </param>
        /// <returns> A new <see cref="HDInsight.HDInsightPrivateEndpointConnectionData"/> instance for mocking. </returns>
        public static HDInsightPrivateEndpointConnectionData HDInsightPrivateEndpointConnectionData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ResourceIdentifier privateEndpointId = null, HDInsightPrivateLinkServiceConnectionState connectionState = null, string linkIdentifier = null, HDInsightPrivateEndpointConnectionProvisioningState? provisioningState = null)
        {
            return new HDInsightPrivateEndpointConnectionData(
                id,
                name,
                resourceType,
                systemData,
                privateEndpointId != null ? ResourceManagerModelFactory.SubResource(privateEndpointId) : null,
                connectionState,
                linkIdentifier,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HDInsightClusterConfigurations"/>. </summary>
        /// <param name="configurations"> The configuration object for the specified configuration for the specified cluster. </param>
        /// <returns> A new <see cref="Models.HDInsightClusterConfigurations"/> instance for mocking. </returns>
        public static HDInsightClusterConfigurations HDInsightClusterConfigurations(IReadOnlyDictionary<string, IDictionary<string, string>> configurations = null)
        {
            configurations ??= new Dictionary<string, IDictionary<string, string>>();

            return new HDInsightClusterConfigurations(configurations, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HDInsightClusterExtensionStatus"/>. </summary>
        /// <param name="isClusterMonitoringEnabled"> The status of the monitor on the HDInsight cluster. </param>
        /// <param name="workspaceId"> The workspace ID of the monitor on the HDInsight cluster. </param>
        /// <returns> A new <see cref="Models.HDInsightClusterExtensionStatus"/> instance for mocking. </returns>
        public static HDInsightClusterExtensionStatus HDInsightClusterExtensionStatus(bool? isClusterMonitoringEnabled = null, string workspaceId = null)
        {
            return new HDInsightClusterExtensionStatus(isClusterMonitoringEnabled, workspaceId, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HDInsightAzureMonitorExtensionStatus"/>. </summary>
        /// <param name="isClusterMonitoringEnabled"> The status of the monitor on the HDInsight cluster. </param>
        /// <param name="workspaceId"> The workspace ID of the monitor on the HDInsight cluster. </param>
        /// <param name="selectedConfigurations"> The selected configurations. </param>
        /// <returns> A new <see cref="Models.HDInsightAzureMonitorExtensionStatus"/> instance for mocking. </returns>
        public static HDInsightAzureMonitorExtensionStatus HDInsightAzureMonitorExtensionStatus(bool? isClusterMonitoringEnabled = null, string workspaceId = null, HDInsightAzureMonitorSelectedConfigurations selectedConfigurations = null)
        {
            return new HDInsightAzureMonitorExtensionStatus(isClusterMonitoringEnabled, workspaceId, selectedConfigurations, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HDInsightCapabilitiesResult"/>. </summary>
        /// <param name="versions"> The version capability. </param>
        /// <param name="regions"> The virtual machine size compatibility features. </param>
        /// <param name="features"> The capability features. </param>
        /// <param name="quota"> The quota capability. </param>
        /// <returns> A new <see cref="Models.HDInsightCapabilitiesResult"/> instance for mocking. </returns>
        public static HDInsightCapabilitiesResult HDInsightCapabilitiesResult(IReadOnlyDictionary<string, HDInsightVersionsCapability> versions = null, IReadOnlyDictionary<string, RegionsCapability> regions = null, IEnumerable<string> features = null, QuotaCapability quota = null)
        {
            versions ??= new Dictionary<string, HDInsightVersionsCapability>();
            regions ??= new Dictionary<string, RegionsCapability>();
            features ??= new List<string>();

            return new HDInsightCapabilitiesResult(versions, regions, features?.ToList(), quota, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HDInsightVersionsCapability"/>. </summary>
        /// <param name="available"> The list of version capabilities. </param>
        /// <returns> A new <see cref="Models.HDInsightVersionsCapability"/> instance for mocking. </returns>
        public static HDInsightVersionsCapability HDInsightVersionsCapability(IEnumerable<HDInsightVersionSpec> available = null)
        {
            available ??= new List<HDInsightVersionSpec>();

            return new HDInsightVersionsCapability(available?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HDInsightVersionSpec"/>. </summary>
        /// <param name="friendlyName"> The friendly name. </param>
        /// <param name="displayName"> The display name. </param>
        /// <param name="isDefault"> Whether or not the version is the default version. </param>
        /// <param name="componentVersions"> The component version property. </param>
        /// <returns> A new <see cref="Models.HDInsightVersionSpec"/> instance for mocking. </returns>
        public static HDInsightVersionSpec HDInsightVersionSpec(string friendlyName = null, string displayName = null, bool? isDefault = null, IReadOnlyDictionary<string, string> componentVersions = null)
        {
            componentVersions ??= new Dictionary<string, string>();

            return new HDInsightVersionSpec(friendlyName, displayName, isDefault, componentVersions, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RegionsCapability"/>. </summary>
        /// <param name="available"> The list of region capabilities. </param>
        /// <returns> A new <see cref="Models.RegionsCapability"/> instance for mocking. </returns>
        public static RegionsCapability RegionsCapability(IEnumerable<string> available = null)
        {
            available ??= new List<string>();

            return new RegionsCapability(available?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.QuotaCapability"/>. </summary>
        /// <param name="coresUsed"> The number of cores used in the subscription. </param>
        /// <param name="maxCoresAllowed"> The number of cores that the subscription allowed. </param>
        /// <param name="regionalQuotas"> The list of region quota capabilities. </param>
        /// <returns> A new <see cref="Models.QuotaCapability"/> instance for mocking. </returns>
        public static QuotaCapability QuotaCapability(long? coresUsed = null, long? maxCoresAllowed = null, IEnumerable<RegionalQuotaCapability> regionalQuotas = null)
        {
            regionalQuotas ??= new List<RegionalQuotaCapability>();

            return new QuotaCapability(coresUsed, maxCoresAllowed, regionalQuotas?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RegionalQuotaCapability"/>. </summary>
        /// <param name="region"> The region name. </param>
        /// <param name="coresUsed"> The number of cores used in the region. </param>
        /// <param name="coresAvailable"> The number of cores available in the region. </param>
        /// <returns> A new <see cref="Models.RegionalQuotaCapability"/> instance for mocking. </returns>
        public static RegionalQuotaCapability RegionalQuotaCapability(AzureLocation? region = null, long? coresUsed = null, long? coresAvailable = null)
        {
            return new RegionalQuotaCapability(region, coresUsed, coresAvailable, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HDInsightUsage"/>. </summary>
        /// <param name="unit"> The type of measurement for usage. </param>
        /// <param name="currentValue"> The current usage. </param>
        /// <param name="limit"> The maximum allowed usage. </param>
        /// <param name="name"> The details about the localizable name of the used resource. </param>
        /// <returns> A new <see cref="Models.HDInsightUsage"/> instance for mocking. </returns>
        public static HDInsightUsage HDInsightUsage(string unit = null, long? currentValue = null, long? limit = null, HDInsightLocalizedName name = null)
        {
            return new HDInsightUsage(unit, currentValue, limit, name, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HDInsightLocalizedName"/>. </summary>
        /// <param name="value"> The name of the used resource. </param>
        /// <param name="localizedValue"> The localized name of the used resource. </param>
        /// <returns> A new <see cref="Models.HDInsightLocalizedName"/> instance for mocking. </returns>
        public static HDInsightLocalizedName HDInsightLocalizedName(string value = null, string localizedValue = null)
        {
            return new HDInsightLocalizedName(value, localizedValue, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HDInsightBillingSpecsListResult"/>. </summary>
        /// <param name="vmSizes"> The virtual machine sizes to include or exclude. </param>
        /// <param name="vmSizesWithEncryptionAtHost"> The vm sizes which enable encryption at host. </param>
        /// <param name="vmSizeFilters"> The virtual machine filtering mode. Effectively this can enabling or disabling the virtual machine sizes in a particular set. </param>
        /// <param name="vmSizeProperties"> The vm size properties. </param>
        /// <param name="billingResources"> The billing and managed disk billing resources for a region. </param>
        /// <returns> A new <see cref="Models.HDInsightBillingSpecsListResult"/> instance for mocking. </returns>
        public static HDInsightBillingSpecsListResult HDInsightBillingSpecsListResult(IEnumerable<string> vmSizes = null, IEnumerable<string> vmSizesWithEncryptionAtHost = null, IEnumerable<HDInsightVmSizeCompatibilityFilterV2> vmSizeFilters = null, IEnumerable<HDInsightVmSizeProperty> vmSizeProperties = null, IEnumerable<HDInsightBillingResources> billingResources = null)
        {
            vmSizes ??= new List<string>();
            vmSizesWithEncryptionAtHost ??= new List<string>();
            vmSizeFilters ??= new List<HDInsightVmSizeCompatibilityFilterV2>();
            vmSizeProperties ??= new List<HDInsightVmSizeProperty>();
            billingResources ??= new List<HDInsightBillingResources>();

            return new HDInsightBillingSpecsListResult(
                vmSizes?.ToList(),
                vmSizesWithEncryptionAtHost?.ToList(),
                vmSizeFilters?.ToList(),
                vmSizeProperties?.ToList(),
                billingResources?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HDInsightVmSizeCompatibilityFilterV2"/>. </summary>
        /// <param name="filterMode"> The filtering mode. Effectively this can enabling or disabling the VM sizes in a particular set. </param>
        /// <param name="regions"> The list of regions under the effect of the filter. </param>
        /// <param name="clusterFlavors"> The list of cluster flavors under the effect of the filter. </param>
        /// <param name="nodeTypes"> The list of node types affected by the filter. </param>
        /// <param name="clusterVersions"> The list of cluster versions affected in Major.Minor format. </param>
        /// <param name="osType"> The OSType affected, Windows or Linux. </param>
        /// <param name="vmSizes"> The list of virtual machine sizes to include or exclude. </param>
        /// <param name="espApplied"> Whether apply for ESP cluster. 'true' means only for ESP, 'false' means only for non-ESP, null or empty string or others mean for both. </param>
        /// <param name="isComputeIsolationSupported"> Whether support compute isolation. 'true' means only for ComputeIsolationEnabled, 'false' means only for regular cluster. </param>
        /// <returns> A new <see cref="Models.HDInsightVmSizeCompatibilityFilterV2"/> instance for mocking. </returns>
        public static HDInsightVmSizeCompatibilityFilterV2 HDInsightVmSizeCompatibilityFilterV2(HDInsightFilterMode? filterMode = null, IEnumerable<string> regions = null, IEnumerable<string> clusterFlavors = null, IEnumerable<string> nodeTypes = null, IEnumerable<string> clusterVersions = null, IEnumerable<HDInsightOSType> osType = null, IEnumerable<string> vmSizes = null, string espApplied = null, string isComputeIsolationSupported = null)
        {
            regions ??= new List<string>();
            clusterFlavors ??= new List<string>();
            nodeTypes ??= new List<string>();
            clusterVersions ??= new List<string>();
            osType ??= new List<HDInsightOSType>();
            vmSizes ??= new List<string>();

            return new HDInsightVmSizeCompatibilityFilterV2(
                filterMode,
                regions?.ToList(),
                clusterFlavors?.ToList(),
                nodeTypes?.ToList(),
                clusterVersions?.ToList(),
                osType?.ToList(),
                vmSizes?.ToList(),
                espApplied,
                isComputeIsolationSupported,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HDInsightVmSizeProperty"/>. </summary>
        /// <param name="name"> The vm size name. </param>
        /// <param name="cores"> The number of cores that the vm size has. </param>
        /// <param name="dataDiskStorageTier"> The data disk storage tier of the vm size. </param>
        /// <param name="label"> The label of the vm size. </param>
        /// <param name="maxDataDiskCount"> The max data disk count of the vm size. </param>
        /// <param name="memoryInMB"> The memory whose unit is MB of the vm size. </param>
        /// <param name="isSupportedByVirtualMachines"> This indicates this vm size is supported by virtual machines or not. </param>
        /// <param name="isSupportedByWebWorkerRoles"> The indicates this vm size is supported by web worker roles or not. </param>
        /// <param name="virtualMachineResourceDiskSizeInMB"> The virtual machine resource disk size whose unit is MB of the vm size. </param>
        /// <param name="webWorkerResourceDiskSizeInMB"> The web worker resource disk size whose unit is MB of the vm size. </param>
        /// <returns> A new <see cref="Models.HDInsightVmSizeProperty"/> instance for mocking. </returns>
        public static HDInsightVmSizeProperty HDInsightVmSizeProperty(string name = null, int? cores = null, string dataDiskStorageTier = null, string label = null, long? maxDataDiskCount = null, long? memoryInMB = null, bool? isSupportedByVirtualMachines = null, bool? isSupportedByWebWorkerRoles = null, long? virtualMachineResourceDiskSizeInMB = null, long? webWorkerResourceDiskSizeInMB = null)
        {
            return new HDInsightVmSizeProperty(
                name,
                cores,
                dataDiskStorageTier,
                label,
                maxDataDiskCount,
                memoryInMB,
                isSupportedByVirtualMachines,
                isSupportedByWebWorkerRoles,
                virtualMachineResourceDiskSizeInMB,
                webWorkerResourceDiskSizeInMB,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HDInsightBillingResources"/>. </summary>
        /// <param name="region"> The region or location. </param>
        /// <param name="billingMeters"> The billing meter information. </param>
        /// <param name="diskBillingMeters"> The managed disk billing information. </param>
        /// <returns> A new <see cref="Models.HDInsightBillingResources"/> instance for mocking. </returns>
        public static HDInsightBillingResources HDInsightBillingResources(AzureLocation? region = null, IEnumerable<HDInsightBillingMeters> billingMeters = null, IEnumerable<HDInsightDiskBillingMeters> diskBillingMeters = null)
        {
            billingMeters ??= new List<HDInsightBillingMeters>();
            diskBillingMeters ??= new List<HDInsightDiskBillingMeters>();

            return new HDInsightBillingResources(region, billingMeters?.ToList(), diskBillingMeters?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HDInsightBillingMeters"/>. </summary>
        /// <param name="meterParameter"> The virtual machine sizes. </param>
        /// <param name="meter"> The HDInsight meter guid. </param>
        /// <param name="unit"> The unit of meter, VMHours or CoreHours. </param>
        /// <returns> A new <see cref="Models.HDInsightBillingMeters"/> instance for mocking. </returns>
        public static HDInsightBillingMeters HDInsightBillingMeters(string meterParameter = null, string meter = null, string unit = null)
        {
            return new HDInsightBillingMeters(meterParameter, meter, unit, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HDInsightDiskBillingMeters"/>. </summary>
        /// <param name="diskRpMeter"> The managed disk meter guid. </param>
        /// <param name="sku"> The managed disk billing sku, P30 or S30. </param>
        /// <param name="tier"> The managed disk billing tier, Standard or Premium. </param>
        /// <returns> A new <see cref="Models.HDInsightDiskBillingMeters"/> instance for mocking. </returns>
        public static HDInsightDiskBillingMeters HDInsightDiskBillingMeters(string diskRpMeter = null, string sku = null, HDInsightTier? tier = null)
        {
            return new HDInsightDiskBillingMeters(diskRpMeter, sku, tier, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HDInsightNameAvailabilityResult"/>. </summary>
        /// <param name="isNameAvailable"> This indicates whether the name is available. </param>
        /// <param name="reason"> The reason of the result. </param>
        /// <param name="message"> The related message. </param>
        /// <returns> A new <see cref="Models.HDInsightNameAvailabilityResult"/> instance for mocking. </returns>
        public static HDInsightNameAvailabilityResult HDInsightNameAvailabilityResult(bool? isNameAvailable = null, string reason = null, string message = null)
        {
            return new HDInsightNameAvailabilityResult(isNameAvailable, reason, message, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HDInsightClusterCreationValidateResult"/>. </summary>
        /// <param name="validationErrors"> The validation errors. </param>
        /// <param name="validationWarnings"> The validation warnings. </param>
        /// <param name="estimatedCreationDuration"> The estimated creation duration. </param>
        /// <param name="aaddsResourcesDetails"> The Azure active directory domain service resource details. </param>
        /// <returns> A new <see cref="Models.HDInsightClusterCreationValidateResult"/> instance for mocking. </returns>
        public static HDInsightClusterCreationValidateResult HDInsightClusterCreationValidateResult(IEnumerable<HDInsightClusterValidationErrorInfo> validationErrors = null, IEnumerable<HDInsightClusterValidationErrorInfo> validationWarnings = null, TimeSpan? estimatedCreationDuration = null, IEnumerable<HDInsightClusterAaddsDetail> aaddsResourcesDetails = null)
        {
            validationErrors ??= new List<HDInsightClusterValidationErrorInfo>();
            validationWarnings ??= new List<HDInsightClusterValidationErrorInfo>();
            aaddsResourcesDetails ??= new List<HDInsightClusterAaddsDetail>();

            return new HDInsightClusterCreationValidateResult(validationErrors?.ToList(), validationWarnings?.ToList(), estimatedCreationDuration, aaddsResourcesDetails?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HDInsightClusterValidationErrorInfo"/>. </summary>
        /// <param name="code"> The error code. </param>
        /// <param name="message"> The error message. </param>
        /// <param name="errorResource"> The error resource. </param>
        /// <param name="messageArguments"> The message arguments. </param>
        /// <returns> A new <see cref="Models.HDInsightClusterValidationErrorInfo"/> instance for mocking. </returns>
        public static HDInsightClusterValidationErrorInfo HDInsightClusterValidationErrorInfo(string code = null, string message = null, string errorResource = null, IEnumerable<string> messageArguments = null)
        {
            messageArguments ??= new List<string>();

            return new HDInsightClusterValidationErrorInfo(code, message, errorResource, messageArguments?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HDInsightClusterAaddsDetail"/>. </summary>
        /// <param name="domainName"> The Azure active directory domain service name. </param>
        /// <param name="isInitialSyncComplete"> This indicates whether initial sync complete or not. </param>
        /// <param name="isLdapsEnabled"> This indicates whether enable ldaps or not. </param>
        /// <param name="ldapsPublicCertificateInBase64"> The base 64 format string of public ldap certificate. </param>
        /// <param name="resourceId"> The resource id of azure active directory domain service. </param>
        /// <param name="subnetId"> The subnet resource id. </param>
        /// <param name="tenantId"> The tenant id of azure active directory domain service . </param>
        /// <returns> A new <see cref="Models.HDInsightClusterAaddsDetail"/> instance for mocking. </returns>
        public static HDInsightClusterAaddsDetail HDInsightClusterAaddsDetail(string domainName = null, bool? isInitialSyncComplete = null, bool? isLdapsEnabled = null, string ldapsPublicCertificateInBase64 = null, ResourceIdentifier resourceId = null, ResourceIdentifier subnetId = null, Guid? tenantId = null)
        {
            return new HDInsightClusterAaddsDetail(
                domainName,
                isInitialSyncComplete,
                isLdapsEnabled,
                ldapsPublicCertificateInBase64,
                resourceId,
                subnetId,
                tenantId,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="HDInsight.HDInsightPrivateLinkResourceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="groupId"> The private link resource group id. </param>
        /// <param name="requiredMembers"> The private link resource required member names. </param>
        /// <param name="requiredZoneNames"> The private link resource Private link DNS zone name. </param>
        /// <returns> A new <see cref="HDInsight.HDInsightPrivateLinkResourceData"/> instance for mocking. </returns>
        public static HDInsightPrivateLinkResourceData HDInsightPrivateLinkResourceData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string groupId = null, IEnumerable<string> requiredMembers = null, IEnumerable<string> requiredZoneNames = null)
        {
            requiredMembers ??= new List<string>();
            requiredZoneNames ??= new List<string>();

            return new HDInsightPrivateLinkResourceData(
                id,
                name,
                resourceType,
                systemData,
                groupId,
                requiredMembers?.ToList(),
                requiredZoneNames?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ExecuteScriptActionContent"/>. </summary>
        /// <param name="scriptActions"> The list of run time script actions. </param>
        /// <param name="persistOnSuccess"> Gets or sets if the scripts needs to be persisted. </param>
        /// <returns> A new <see cref="Models.ExecuteScriptActionContent"/> instance for mocking. </returns>
        public static ExecuteScriptActionContent ExecuteScriptActionContent(IEnumerable<RuntimeScriptAction> scriptActions = null, bool persistOnSuccess = default)
        {
            scriptActions ??= new List<RuntimeScriptAction>();

            return new ExecuteScriptActionContent(scriptActions?.ToList(), persistOnSuccess, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RuntimeScriptActionDetail"/>. </summary>
        /// <param name="name"> The name of the script action. </param>
        /// <param name="uri"> The URI to the script. </param>
        /// <param name="parameters"> The parameters for the script. </param>
        /// <param name="roles"> The list of roles where script will be executed. </param>
        /// <param name="applicationName"> The application name of the script action, if any. </param>
        /// <param name="scriptExecutionId"> The execution id of the script action. </param>
        /// <param name="startOn"> The start time of script action execution. </param>
        /// <param name="endOn"> The end time of script action execution. </param>
        /// <param name="status"> The current execution status of the script action. </param>
        /// <param name="operation"> The reason why the script action was executed. </param>
        /// <param name="executionSummary"> The summary of script action execution result. </param>
        /// <param name="debugInformation"> The script action execution debug information. </param>
        /// <returns> A new <see cref="Models.RuntimeScriptActionDetail"/> instance for mocking. </returns>
        public static RuntimeScriptActionDetail RuntimeScriptActionDetail(string name = null, Uri uri = null, string parameters = null, IEnumerable<string> roles = null, string applicationName = null, long? scriptExecutionId = null, DateTimeOffset? startOn = null, DateTimeOffset? endOn = null, string status = null, string operation = null, IEnumerable<ScriptActionExecutionSummary> executionSummary = null, string debugInformation = null)
        {
            roles ??= new List<string>();
            executionSummary ??= new List<ScriptActionExecutionSummary>();

            return new RuntimeScriptActionDetail(
                name,
                uri,
                parameters,
                roles?.ToList(),
                applicationName,
                serializedAdditionalRawData: null,
                scriptExecutionId,
                startOn,
                endOn,
                status,
                operation,
                executionSummary?.ToList(),
                debugInformation);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ScriptActionExecutionSummary"/>. </summary>
        /// <param name="status"> The status of script action execution. </param>
        /// <param name="instanceCount"> The instance count for a given script action execution status. </param>
        /// <returns> A new <see cref="Models.ScriptActionExecutionSummary"/> instance for mocking. </returns>
        public static ScriptActionExecutionSummary ScriptActionExecutionSummary(string status = null, int? instanceCount = null)
        {
            return new ScriptActionExecutionSummary(status, instanceCount, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HDInsightClusterHostInfo"/>. </summary>
        /// <param name="name"> The host name. </param>
        /// <param name="fqdn"> The Fully Qualified Domain Name of host. </param>
        /// <param name="effectiveDiskEncryptionKeyUri"> The effective disk encryption key URL used by the host. </param>
        /// <returns> A new <see cref="Models.HDInsightClusterHostInfo"/> instance for mocking. </returns>
        public static HDInsightClusterHostInfo HDInsightClusterHostInfo(string name = null, string fqdn = null, Uri effectiveDiskEncryptionKeyUri = null)
        {
            return new HDInsightClusterHostInfo(name, fqdn, effectiveDiskEncryptionKeyUri, serializedAdditionalRawData: null);
        }
    }
}
