// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.HDInsight.Models;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.HDInsight.Samples
{
    public partial class Sample_SubscriptionResourceExtensions
    {
        // Get the subscription capabilities for specific location
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetHDInsightCapabilities_GetTheSubscriptionCapabilitiesForSpecificLocation()
        {
            // Generated from example definition: specification/hdinsight/resource-manager/Microsoft.HDInsight/preview/2024-08-01-preview/examples/GetHDInsightCapabilities.json
            // this example is just showing the usage of "Locations_GetCapabilities" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "subid";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation
            AzureLocation location = new AzureLocation("West US");
            HDInsightCapabilitiesResult result = await subscriptionResource.GetHDInsightCapabilitiesAsync(location);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get the subscription usages for specific location
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetHDInsightUsages_GetTheSubscriptionUsagesForSpecificLocation()
        {
            // Generated from example definition: specification/hdinsight/resource-manager/Microsoft.HDInsight/preview/2024-08-01-preview/examples/GetHDInsightUsages.json
            // this example is just showing the usage of "Locations_ListUsages" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "subid";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation and iterate over the result
            AzureLocation location = new AzureLocation("West US");
            await foreach (HDInsightUsage item in subscriptionResource.GetHDInsightUsagesAsync(location))
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Get the subscription billingSpecs for the specified location
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetHDInsightBillingSpecs_GetTheSubscriptionBillingSpecsForTheSpecifiedLocation()
        {
            // Generated from example definition: specification/hdinsight/resource-manager/Microsoft.HDInsight/preview/2024-08-01-preview/examples/HDI_Locations_ListBillingSpecs.json
            // this example is just showing the usage of "Locations_ListBillingSpecs" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "subid";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation
            AzureLocation location = new AzureLocation("East US 2");
            HDInsightBillingSpecsListResult result = await subscriptionResource.GetHDInsightBillingSpecsAsync(location);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get the subscription usages for specific location
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CheckHDInsightNameAvailability_GetTheSubscriptionUsagesForSpecificLocation()
        {
            // Generated from example definition: specification/hdinsight/resource-manager/Microsoft.HDInsight/preview/2024-08-01-preview/examples/HDI_Locations_CheckClusterNameAvailability.json
            // this example is just showing the usage of "Locations_CheckNameAvailability" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "subid";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation
            AzureLocation location = new AzureLocation("westus");
            HDInsightNameAvailabilityContent content = new HDInsightNameAvailabilityContent()
            {
                Name = "test123",
                ResourceType = new ResourceType("clusters"),
            };
            HDInsightNameAvailabilityResult result = await subscriptionResource.CheckHDInsightNameAvailabilityAsync(location, content);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get the subscription usages for specific location
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task ValidateHDInsightClusterCreation_GetTheSubscriptionUsagesForSpecificLocation()
        {
            // Generated from example definition: specification/hdinsight/resource-manager/Microsoft.HDInsight/preview/2024-08-01-preview/examples/HDI_Locations_ValidateClusterCreateRequest.json
            // this example is just showing the usage of "Locations_ValidateClusterCreateRequest" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "subid";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation
            AzureLocation location = new AzureLocation("southcentralus");
            HDInsightClusterCreationValidateContent content = new HDInsightClusterCreationValidateContent()
            {
                Name = "testclustername",
                ClusterCreateRequestValidationParametersType = "Microsoft.HDInsight/clusters",
                TenantId = Guid.Parse("00000000-0000-0000-0000-000000000000"),
                FetchAaddsResource = false,
                Location = new AzureLocation("southcentralus"),
                Tags =
{
},
                Properties = new HDInsightClusterCreateOrUpdateProperties()
                {
                    ClusterVersion = "4.0",
                    OSType = HDInsightOSType.Linux,
                    Tier = HDInsightTier.Standard,
                    ClusterDefinition = new HDInsightClusterDefinition()
                    {
                        Kind = "spark",
                        ComponentVersion =
{
["Spark"] = "2.4",
},
                        Configurations = BinaryData.FromObjectAsJson(new Dictionary<string, object>()
                        {
                            ["gateway"] = new Dictionary<string, object>()
                            {
                                ["restAuthCredential.isEnabled"] = "true",
                                ["restAuthCredential.password"] = "**********",
                                ["restAuthCredential.username"] = "admin"
                            }
                        }),
                    },
                    ComputeRoles =
{
new HDInsightClusterRole()
{
Name = "headnode",
MinInstanceCount = 1,
TargetInstanceCount = 2,
AutoScaleConfiguration = null,
HardwareVmSize = "Standard_E8_V3",
OSLinuxProfile = new HDInsightLinuxOSProfile()
{
Username = "sshuser",
Password = "********",
},
VirtualNetworkProfile = null,
DataDisksGroups =
{
},
ScriptActions =
{
},
},new HDInsightClusterRole()
{
Name = "workernode",
TargetInstanceCount = 4,
AutoScaleConfiguration = null,
HardwareVmSize = "Standard_E8_V3",
OSLinuxProfile = new HDInsightLinuxOSProfile()
{
Username = "sshuser",
Password = "********",
},
VirtualNetworkProfile = null,
DataDisksGroups =
{
},
ScriptActions =
{
},
},new HDInsightClusterRole()
{
Name = "zookeepernode",
MinInstanceCount = 1,
TargetInstanceCount = 3,
AutoScaleConfiguration = null,
HardwareVmSize = "Standard_D13_V2",
OSLinuxProfile = new HDInsightLinuxOSProfile()
{
Username = "sshuser",
Password = "**********",
},
VirtualNetworkProfile = null,
DataDisksGroups =
{
},
ScriptActions =
{
},
}
},
                    StorageAccounts =
{
new HDInsightStorageAccountInfo()
{
Name = "storagename.blob.core.windows.net",
IsDefault = true,
Container = "contianername",
Key = "*******",
ResourceId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Storage/storageAccounts/storagename"),
EnableSecureChannel = true,
}
},
                    MinSupportedTlsVersion = "1.2",
                },
            };
            HDInsightClusterCreationValidateResult result = await subscriptionResource.ValidateHDInsightClusterCreationAsync(location, content);

            Console.WriteLine($"Succeeded: {result}");
        }
    }
}
