// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.HDInsight.Models;

namespace Azure.ResourceManager.HDInsight.Samples
{
    public partial class Sample_HDInsightPrivateEndpointConnectionResource
    {
        // Approve a private endpoint connection manually.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_ApproveAPrivateEndpointConnectionManually()
        {
            // Generated from example definition: specification/hdinsight/resource-manager/Microsoft.HDInsight/preview/2024-08-01-preview/examples/ApprovePrivateEndpointConnection.json
            // this example is just showing the usage of "PrivateEndpointConnections_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this HDInsightPrivateEndpointConnectionResource created on azure
            // for more information of creating HDInsightPrivateEndpointConnectionResource, please refer to the document of HDInsightPrivateEndpointConnectionResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string clusterName = "cluster1";
            string privateEndpointConnectionName = "testprivateep.b3bf5fed-9b12-4560-b7d0-2abe1bba07e2";
            ResourceIdentifier hdInsightPrivateEndpointConnectionResourceId = HDInsightPrivateEndpointConnectionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, clusterName, privateEndpointConnectionName);
            HDInsightPrivateEndpointConnectionResource hdInsightPrivateEndpointConnection = client.GetHDInsightPrivateEndpointConnectionResource(hdInsightPrivateEndpointConnectionResourceId);

            // invoke the operation
            HDInsightPrivateEndpointConnectionData data = new HDInsightPrivateEndpointConnectionData(new HDInsightPrivateLinkServiceConnectionState(HDInsightPrivateLinkServiceConnectionStatus.Approved)
            {
                Description = "update it from pending to approved.",
                ActionsRequired = "None",
            });
            ArmOperation<HDInsightPrivateEndpointConnectionResource> lro = await hdInsightPrivateEndpointConnection.UpdateAsync(WaitUntil.Completed, data);
            HDInsightPrivateEndpointConnectionResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            HDInsightPrivateEndpointConnectionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get specific private endpoint connection for a specific HDInsight cluster.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetSpecificPrivateEndpointConnectionForASpecificHDInsightCluster()
        {
            // Generated from example definition: specification/hdinsight/resource-manager/Microsoft.HDInsight/preview/2024-08-01-preview/examples/GetPrivateEndpointConnection.json
            // this example is just showing the usage of "PrivateEndpointConnections_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this HDInsightPrivateEndpointConnectionResource created on azure
            // for more information of creating HDInsightPrivateEndpointConnectionResource, please refer to the document of HDInsightPrivateEndpointConnectionResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string clusterName = "cluster1";
            string privateEndpointConnectionName = "testprivateep.b3bf5fed-9b12-4560-b7d0-2abe1bba07e2";
            ResourceIdentifier hdInsightPrivateEndpointConnectionResourceId = HDInsightPrivateEndpointConnectionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, clusterName, privateEndpointConnectionName);
            HDInsightPrivateEndpointConnectionResource hdInsightPrivateEndpointConnection = client.GetHDInsightPrivateEndpointConnectionResource(hdInsightPrivateEndpointConnectionResourceId);

            // invoke the operation
            HDInsightPrivateEndpointConnectionResource result = await hdInsightPrivateEndpointConnection.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            HDInsightPrivateEndpointConnectionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Delete specific private endpoint connection for a specific HDInsight cluster.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteSpecificPrivateEndpointConnectionForASpecificHDInsightCluster()
        {
            // Generated from example definition: specification/hdinsight/resource-manager/Microsoft.HDInsight/preview/2024-08-01-preview/examples/DeletePrivateEndpointConnection.json
            // this example is just showing the usage of "PrivateEndpointConnections_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this HDInsightPrivateEndpointConnectionResource created on azure
            // for more information of creating HDInsightPrivateEndpointConnectionResource, please refer to the document of HDInsightPrivateEndpointConnectionResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string clusterName = "cluster1";
            string privateEndpointConnectionName = "testprivateep.b3bf5fed-9b12-4560-b7d0-2abe1bba07e2";
            ResourceIdentifier hdInsightPrivateEndpointConnectionResourceId = HDInsightPrivateEndpointConnectionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, clusterName, privateEndpointConnectionName);
            HDInsightPrivateEndpointConnectionResource hdInsightPrivateEndpointConnection = client.GetHDInsightPrivateEndpointConnectionResource(hdInsightPrivateEndpointConnectionResourceId);

            // invoke the operation
            await hdInsightPrivateEndpointConnection.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
