// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.HDInsight.Models;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.HDInsight.Samples
{
    public partial class Sample_HDInsightClusterCollection
    {
        // Create HDInsight cluster with Autoscale configuration
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateHDInsightClusterWithAutoscaleConfiguration()
        {
            // Generated from example definition: specification/hdinsight/resource-manager/Microsoft.HDInsight/preview/2024-08-01-preview/examples/CreateHDInsightClusterWithAutoscaleConfig.json
            // this example is just showing the usage of "Clusters_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this HDInsightClusterResource
            HDInsightClusterCollection collection = resourceGroupResource.GetHDInsightClusters();

            // invoke the operation
            string clusterName = "cluster1";
            HDInsightClusterCreateOrUpdateContent content = new HDInsightClusterCreateOrUpdateContent()
            {
                Properties = new HDInsightClusterCreateOrUpdateProperties()
                {
                    ClusterVersion = "3.6",
                    OSType = HDInsightOSType.Linux,
                    Tier = HDInsightTier.Standard,
                    ClusterDefinition = new HDInsightClusterDefinition()
                    {
                        Kind = "hadoop",
                        ComponentVersion =
{
["Hadoop"] = "2.7",
},
                        Configurations = BinaryData.FromObjectAsJson(new Dictionary<string, object>()
                        {
                            ["gateway"] = new Dictionary<string, object>()
                            {
                                ["restAuthCredential.isEnabled"] = "true",
                                ["restAuthCredential.password"] = "**********",
                                ["restAuthCredential.username"] = "admin"
                            }
                        }),
                    },
                    ComputeRoles =
{
new HDInsightClusterRole()
{
Name = "workernode",
TargetInstanceCount = 4,
AutoScaleConfiguration = new HDInsightAutoScaleConfiguration()
{
Capacity = null,
Recurrence = new HDInsightAutoScaleRecurrence()
{
TimeZone = "China Standard Time",
Schedule =
{
new HDInsightAutoScaleSchedule()
{
Days =
{
HDInsightDayOfWeek.Monday,HDInsightDayOfWeek.Tuesday,HDInsightDayOfWeek.Wednesday,HDInsightDayOfWeek.Thursday,HDInsightDayOfWeek.Friday
},
TimeAndCapacity = new HDInsightAutoScaleTimeAndCapacity()
{
Time = "09:00",
MinInstanceCount = 3,
MaxInstanceCount = 3,
},
},new HDInsightAutoScaleSchedule()
{
Days =
{
HDInsightDayOfWeek.Monday,HDInsightDayOfWeek.Tuesday,HDInsightDayOfWeek.Wednesday,HDInsightDayOfWeek.Thursday,HDInsightDayOfWeek.Friday
},
TimeAndCapacity = new HDInsightAutoScaleTimeAndCapacity()
{
Time = "18:00",
MinInstanceCount = 6,
MaxInstanceCount = 6,
},
},new HDInsightAutoScaleSchedule()
{
Days =
{
HDInsightDayOfWeek.Saturday,HDInsightDayOfWeek.Sunday
},
TimeAndCapacity = new HDInsightAutoScaleTimeAndCapacity()
{
Time = "09:00",
MinInstanceCount = 2,
MaxInstanceCount = 2,
},
},new HDInsightAutoScaleSchedule()
{
Days =
{
HDInsightDayOfWeek.Saturday,HDInsightDayOfWeek.Sunday
},
TimeAndCapacity = new HDInsightAutoScaleTimeAndCapacity()
{
Time = "18:00",
MinInstanceCount = 4,
MaxInstanceCount = 4,
},
}
},
},
},
HardwareVmSize = "Standard_D4_V2",
OSLinuxProfile = new HDInsightLinuxOSProfile()
{
Username = "sshuser",
Password = "**********",
},
VirtualNetworkProfile = null,
DataDisksGroups =
{
},
ScriptActions =
{
},
}
},
                    StorageAccounts =
{
new HDInsightStorageAccountInfo()
{
Name = "mystorage.blob.core.windows.net",
IsDefault = true,
Container = "hdinsight-autoscale-tes-2019-06-18t05-49-16-591z",
Key = "storagekey",
EnableSecureChannel = true,
}
},
                },
            };
            ArmOperation<HDInsightClusterResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, clusterName, content);
            HDInsightClusterResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            HDInsightClusterData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create Hadoop cluster with Azure Data Lake Storage Gen 2
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateHadoopClusterWithAzureDataLakeStorageGen2()
        {
            // Generated from example definition: specification/hdinsight/resource-manager/Microsoft.HDInsight/preview/2024-08-01-preview/examples/CreateLinuxHadoopAdlsGen2.json
            // this example is just showing the usage of "Clusters_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this HDInsightClusterResource
            HDInsightClusterCollection collection = resourceGroupResource.GetHDInsightClusters();

            // invoke the operation
            string clusterName = "cluster1";
            HDInsightClusterCreateOrUpdateContent content = new HDInsightClusterCreateOrUpdateContent()
            {
                Tags =
{
["key1"] = "val1",
},
                Properties = new HDInsightClusterCreateOrUpdateProperties()
                {
                    ClusterVersion = "3.6",
                    OSType = HDInsightOSType.Linux,
                    Tier = HDInsightTier.Standard,
                    ClusterDefinition = new HDInsightClusterDefinition()
                    {
                        Kind = "Hadoop",
                        Configurations = BinaryData.FromObjectAsJson(new Dictionary<string, object>()
                        {
                            ["gateway"] = new Dictionary<string, object>()
                            {
                                ["restAuthCredential.isEnabled"] = "true",
                                ["restAuthCredential.password"] = "**********",
                                ["restAuthCredential.username"] = "admin"
                            }
                        }),
                    },
                    ComputeRoles =
{
new HDInsightClusterRole()
{
Name = "headnode",
MinInstanceCount = 1,
TargetInstanceCount = 2,
HardwareVmSize = "Standard_D3_V2",
OSLinuxProfile = new HDInsightLinuxOSProfile()
{
Username = "sshuser",
Password = "**********",
},
},new HDInsightClusterRole()
{
Name = "workernode",
MinInstanceCount = 1,
TargetInstanceCount = 4,
HardwareVmSize = "Standard_D3_V2",
OSLinuxProfile = new HDInsightLinuxOSProfile()
{
Username = "sshuser",
Password = "**********",
},
},new HDInsightClusterRole()
{
Name = "zookeepernode",
MinInstanceCount = 1,
TargetInstanceCount = 3,
HardwareVmSize = "Small",
OSLinuxProfile = new HDInsightLinuxOSProfile()
{
Username = "sshuser",
Password = "**********",
},
}
},
                    StorageAccounts =
{
new HDInsightStorageAccountInfo()
{
Name = "mystorage.dfs.core.windows.net",
IsDefault = true,
FileSystem = "default",
Key = "storagekey",
EnableSecureChannel = true,
}
},
                },
            };
            ArmOperation<HDInsightClusterResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, clusterName, content);
            HDInsightClusterResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            HDInsightClusterData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create Hadoop on Linux cluster with SSH password
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateHadoopOnLinuxClusterWithSSHPassword()
        {
            // Generated from example definition: specification/hdinsight/resource-manager/Microsoft.HDInsight/preview/2024-08-01-preview/examples/CreateLinuxHadoopSshPassword.json
            // this example is just showing the usage of "Clusters_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this HDInsightClusterResource
            HDInsightClusterCollection collection = resourceGroupResource.GetHDInsightClusters();

            // invoke the operation
            string clusterName = "cluster1";
            HDInsightClusterCreateOrUpdateContent content = new HDInsightClusterCreateOrUpdateContent()
            {
                Tags =
{
["key1"] = "val1",
},
                Properties = new HDInsightClusterCreateOrUpdateProperties()
                {
                    ClusterVersion = "3.5",
                    OSType = HDInsightOSType.Linux,
                    Tier = HDInsightTier.Standard,
                    ClusterDefinition = new HDInsightClusterDefinition()
                    {
                        Kind = "Hadoop",
                        Configurations = BinaryData.FromObjectAsJson(new Dictionary<string, object>()
                        {
                            ["gateway"] = new Dictionary<string, object>()
                            {
                                ["restAuthCredential.isEnabled"] = "true",
                                ["restAuthCredential.password"] = "**********",
                                ["restAuthCredential.username"] = "admin"
                            }
                        }),
                    },
                    ComputeRoles =
{
new HDInsightClusterRole()
{
Name = "headnode",
MinInstanceCount = 1,
TargetInstanceCount = 2,
HardwareVmSize = "Standard_D3_V2",
OSLinuxProfile = new HDInsightLinuxOSProfile()
{
Username = "sshuser",
Password = "**********",
},
},new HDInsightClusterRole()
{
Name = "workernode",
MinInstanceCount = 1,
TargetInstanceCount = 4,
HardwareVmSize = "Standard_D3_V2",
OSLinuxProfile = new HDInsightLinuxOSProfile()
{
Username = "sshuser",
Password = "**********",
},
},new HDInsightClusterRole()
{
Name = "zookeepernode",
MinInstanceCount = 1,
TargetInstanceCount = 3,
HardwareVmSize = "Small",
OSLinuxProfile = new HDInsightLinuxOSProfile()
{
Username = "sshuser",
Password = "**********",
},
}
},
                    StorageAccounts =
{
new HDInsightStorageAccountInfo()
{
Name = "mystorage.blob.core.windows.net",
IsDefault = true,
Container = "containername",
Key = "storagekey",
EnableSecureChannel = true,
}
},
                },
            };
            ArmOperation<HDInsightClusterResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, clusterName, content);
            HDInsightClusterResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            HDInsightClusterData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create Hadoop on Linux cluster with SSH public key
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateHadoopOnLinuxClusterWithSSHPublicKey()
        {
            // Generated from example definition: specification/hdinsight/resource-manager/Microsoft.HDInsight/preview/2024-08-01-preview/examples/CreateLinuxHadoopSshPublicKey.json
            // this example is just showing the usage of "Clusters_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this HDInsightClusterResource
            HDInsightClusterCollection collection = resourceGroupResource.GetHDInsightClusters();

            // invoke the operation
            string clusterName = "cluster1";
            HDInsightClusterCreateOrUpdateContent content = new HDInsightClusterCreateOrUpdateContent()
            {
                Tags =
{
["key1"] = "val1",
},
                Properties = new HDInsightClusterCreateOrUpdateProperties()
                {
                    ClusterVersion = "3.5",
                    OSType = HDInsightOSType.Linux,
                    Tier = HDInsightTier.Standard,
                    ClusterDefinition = new HDInsightClusterDefinition()
                    {
                        Kind = "Hadoop",
                        Configurations = BinaryData.FromObjectAsJson(new Dictionary<string, object>()
                        {
                            ["gateway"] = new Dictionary<string, object>()
                            {
                                ["restAuthCredential.isEnabled"] = "true",
                                ["restAuthCredential.password"] = "**********",
                                ["restAuthCredential.username"] = "admin"
                            }
                        }),
                    },
                    ComputeRoles =
{
new HDInsightClusterRole()
{
Name = "headnode",
MinInstanceCount = 1,
TargetInstanceCount = 2,
HardwareVmSize = "Standard_D3_V2",
OSLinuxProfile = new HDInsightLinuxOSProfile()
{
Username = "sshuser",
SshPublicKeys =
{
new HDInsightSshPublicKey()
{
CertificateData = "**********",
}
},
},
},new HDInsightClusterRole()
{
Name = "workernode",
MinInstanceCount = 1,
TargetInstanceCount = 4,
HardwareVmSize = "Standard_D3_V2",
OSLinuxProfile = new HDInsightLinuxOSProfile()
{
Username = "sshuser",
Password = "**********",
},
},new HDInsightClusterRole()
{
Name = "zookeepernode",
MinInstanceCount = 1,
TargetInstanceCount = 3,
HardwareVmSize = "Small",
OSLinuxProfile = new HDInsightLinuxOSProfile()
{
Username = "sshuser",
Password = "**********",
},
}
},
                    StorageAccounts =
{
new HDInsightStorageAccountInfo()
{
Name = "mystorage.blob.core.windows.net",
IsDefault = true,
Container = "containername",
Key = "storagekey",
EnableSecureChannel = true,
}
},
                },
            };
            ArmOperation<HDInsightClusterResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, clusterName, content);
            HDInsightClusterResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            HDInsightClusterData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create Kafka cluster with Kafka Rest Proxy
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateKafkaClusterWithKafkaRestProxy()
        {
            // Generated from example definition: specification/hdinsight/resource-manager/Microsoft.HDInsight/preview/2024-08-01-preview/examples/CreateKafkaClusterWithKafkaRestProxy.json
            // this example is just showing the usage of "Clusters_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this HDInsightClusterResource
            HDInsightClusterCollection collection = resourceGroupResource.GetHDInsightClusters();

            // invoke the operation
            string clusterName = "cluster1";
            HDInsightClusterCreateOrUpdateContent content = new HDInsightClusterCreateOrUpdateContent()
            {
                Properties = new HDInsightClusterCreateOrUpdateProperties()
                {
                    ClusterVersion = "4.0",
                    OSType = HDInsightOSType.Linux,
                    Tier = HDInsightTier.Standard,
                    ClusterDefinition = new HDInsightClusterDefinition()
                    {
                        Kind = "kafka",
                        ComponentVersion =
{
["Kafka"] = "2.1",
},
                        Configurations = BinaryData.FromObjectAsJson(new Dictionary<string, object>()
                        {
                            ["gateway"] = new Dictionary<string, object>()
                            {
                                ["restAuthCredential.isEnabled"] = "true",
                                ["restAuthCredential.password"] = "**********",
                                ["restAuthCredential.username"] = "admin"
                            }
                        }),
                    },
                    KafkaRestProperties = new KafkaRestProperties()
                    {
                        ClientGroupInfo = new ClientGroupInfo()
                        {
                            GroupName = "Kafka security group name",
                            GroupId = "00000000-0000-0000-0000-111111111111",
                        },
                    },
                    ComputeRoles =
{
new HDInsightClusterRole()
{
Name = "headnode",
TargetInstanceCount = 2,
HardwareVmSize = "Large",
OSLinuxProfile = new HDInsightLinuxOSProfile()
{
Username = "sshuser",
Password = "**********",
},
},new HDInsightClusterRole()
{
Name = "workernode",
TargetInstanceCount = 3,
HardwareVmSize = "Large",
OSLinuxProfile = new HDInsightLinuxOSProfile()
{
Username = "sshuser",
Password = "**********",
},
DataDisksGroups =
{
new HDInsightClusterDataDiskGroup()
{
DisksPerNode = 8,
}
},
},new HDInsightClusterRole()
{
Name = "zookeepernode",
TargetInstanceCount = 3,
HardwareVmSize = "Small",
OSLinuxProfile = new HDInsightLinuxOSProfile()
{
Username = "sshuser",
Password = "**********",
},
},new HDInsightClusterRole()
{
Name = "kafkamanagementnode",
TargetInstanceCount = 2,
HardwareVmSize = "Standard_D4_v2",
OSLinuxProfile = new HDInsightLinuxOSProfile()
{
Username = "kafkauser",
Password = "**********",
},
}
},
                    StorageAccounts =
{
new HDInsightStorageAccountInfo()
{
Name = "mystorage.blob.core.windows.net",
IsDefault = true,
Container = "containername",
Key = "storagekey",
EnableSecureChannel = true,
}
},
                },
            };
            ArmOperation<HDInsightClusterResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, clusterName, content);
            HDInsightClusterResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            HDInsightClusterData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create Secure Hadoop cluster
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateSecureHadoopCluster()
        {
            // Generated from example definition: specification/hdinsight/resource-manager/Microsoft.HDInsight/preview/2024-08-01-preview/examples/CreateLinuxHadoopSecureHadoop.json
            // this example is just showing the usage of "Clusters_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this HDInsightClusterResource
            HDInsightClusterCollection collection = resourceGroupResource.GetHDInsightClusters();

            // invoke the operation
            string clusterName = "cluster1";
            HDInsightClusterCreateOrUpdateContent content = new HDInsightClusterCreateOrUpdateContent()
            {
                Tags =
{
["key1"] = "val1",
},
                Properties = new HDInsightClusterCreateOrUpdateProperties()
                {
                    ClusterVersion = "3.5",
                    OSType = HDInsightOSType.Linux,
                    Tier = HDInsightTier.Premium,
                    ClusterDefinition = new HDInsightClusterDefinition()
                    {
                        Kind = "Hadoop",
                        Configurations = BinaryData.FromObjectAsJson(new Dictionary<string, object>()
                        {
                            ["gateway"] = new Dictionary<string, object>()
                            {
                                ["restAuthCredential.isEnabled"] = "true",
                                ["restAuthCredential.password"] = "**********",
                                ["restAuthCredential.username"] = "admin"
                            }
                        }),
                    },
                    SecurityProfile = new HDInsightSecurityProfile()
                    {
                        DirectoryType = AuthenticationDirectoryType.ActiveDirectory,
                        Domain = "DomainName",
                        OrganizationalUnitDN = "OU=Hadoop,DC=hdinsight,DC=test",
                        LdapUris =
{
new Uri("ldaps://10.10.0.4:636")
},
                        DomainUsername = "DomainUsername",
                        DomainUserPassword = "**********",
                        ClusterUsersGroupDNs =
{
"hdiusers"
},
                    },
                    ComputeRoles =
{
new HDInsightClusterRole()
{
Name = "headnode",
MinInstanceCount = 1,
TargetInstanceCount = 2,
HardwareVmSize = "Standard_D3_V2",
OSLinuxProfile = new HDInsightLinuxOSProfile()
{
Username = "sshuser",
Password = "**********",
SshPublicKeys =
{
new HDInsightSshPublicKey()
{
CertificateData = "**********",
}
},
},
VirtualNetworkProfile = new HDInsightVirtualNetworkProfile()
{
Id = new ResourceIdentifier("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname"),
Subnet = "/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname/subnets/vnetsubnet",
},
ScriptActions =
{
},
},new HDInsightClusterRole()
{
Name = "workernode",
MinInstanceCount = 1,
TargetInstanceCount = 4,
HardwareVmSize = "Standard_D3_V2",
OSLinuxProfile = new HDInsightLinuxOSProfile()
{
Username = "sshuser",
Password = "**********",
SshPublicKeys =
{
new HDInsightSshPublicKey()
{
CertificateData = "**********",
}
},
},
VirtualNetworkProfile = new HDInsightVirtualNetworkProfile()
{
Id = new ResourceIdentifier("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname"),
Subnet = "/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname/subnets/vnetsubnet",
},
ScriptActions =
{
},
},new HDInsightClusterRole()
{
Name = "zookeepernode",
MinInstanceCount = 1,
TargetInstanceCount = 3,
HardwareVmSize = "Small",
OSLinuxProfile = new HDInsightLinuxOSProfile()
{
Username = "sshuser",
Password = "**********",
SshPublicKeys =
{
new HDInsightSshPublicKey()
{
CertificateData = "**********",
}
},
},
VirtualNetworkProfile = new HDInsightVirtualNetworkProfile()
{
Id = new ResourceIdentifier("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname"),
Subnet = "/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname/subnets/vnetsubnet",
},
ScriptActions =
{
},
}
},
                    StorageAccounts =
{
new HDInsightStorageAccountInfo()
{
Name = "mystorage.blob.core.windows.net",
IsDefault = true,
Container = "containername",
Key = "storage account key",
EnableSecureChannel = true,
}
},
                },
            };
            ArmOperation<HDInsightClusterResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, clusterName, content);
            HDInsightClusterResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            HDInsightClusterData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create Spark on Linux Cluster with SSH password
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateSparkOnLinuxClusterWithSSHPassword()
        {
            // Generated from example definition: specification/hdinsight/resource-manager/Microsoft.HDInsight/preview/2024-08-01-preview/examples/CreateLinuxSparkSshPassword.json
            // this example is just showing the usage of "Clusters_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this HDInsightClusterResource
            HDInsightClusterCollection collection = resourceGroupResource.GetHDInsightClusters();

            // invoke the operation
            string clusterName = "cluster1";
            HDInsightClusterCreateOrUpdateContent content = new HDInsightClusterCreateOrUpdateContent()
            {
                Tags =
{
["key1"] = "val1",
},
                Properties = new HDInsightClusterCreateOrUpdateProperties()
                {
                    ClusterVersion = "3.5",
                    OSType = HDInsightOSType.Linux,
                    Tier = HDInsightTier.Standard,
                    ClusterDefinition = new HDInsightClusterDefinition()
                    {
                        Kind = "Spark",
                        ComponentVersion =
{
["Spark"] = "2.0",
},
                        Configurations = BinaryData.FromObjectAsJson(new Dictionary<string, object>()
                        {
                            ["gateway"] = new Dictionary<string, object>()
                            {
                                ["restAuthCredential.isEnabled"] = "true",
                                ["restAuthCredential.password"] = "**********",
                                ["restAuthCredential.username"] = "admin"
                            }
                        }),
                    },
                    ComputeRoles =
{
new HDInsightClusterRole()
{
Name = "headnode",
MinInstanceCount = 1,
TargetInstanceCount = 2,
HardwareVmSize = "Standard_D12_V2",
OSLinuxProfile = new HDInsightLinuxOSProfile()
{
Username = "sshuser",
Password = "**********",
},
},new HDInsightClusterRole()
{
Name = "workernode",
MinInstanceCount = 1,
TargetInstanceCount = 4,
HardwareVmSize = "Standard_D4_V2",
OSLinuxProfile = new HDInsightLinuxOSProfile()
{
Username = "sshuser",
Password = "**********",
},
}
},
                    StorageAccounts =
{
new HDInsightStorageAccountInfo()
{
Name = "mystorage.blob.core.windows.net",
IsDefault = true,
Container = "containername",
Key = "storageapikey*",
EnableSecureChannel = true,
}
},
                },
            };
            ArmOperation<HDInsightClusterResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, clusterName, content);
            HDInsightClusterResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            HDInsightClusterData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create cluster with TLS 1.2
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateClusterWithTLS12()
        {
            // Generated from example definition: specification/hdinsight/resource-manager/Microsoft.HDInsight/preview/2024-08-01-preview/examples/CreateHDInsightClusterWithTLS12.json
            // this example is just showing the usage of "Clusters_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this HDInsightClusterResource
            HDInsightClusterCollection collection = resourceGroupResource.GetHDInsightClusters();

            // invoke the operation
            string clusterName = "cluster1";
            HDInsightClusterCreateOrUpdateContent content = new HDInsightClusterCreateOrUpdateContent()
            {
                Properties = new HDInsightClusterCreateOrUpdateProperties()
                {
                    ClusterVersion = "3.6",
                    OSType = HDInsightOSType.Linux,
                    Tier = HDInsightTier.Standard,
                    ClusterDefinition = new HDInsightClusterDefinition()
                    {
                        Kind = "Hadoop",
                        Configurations = BinaryData.FromObjectAsJson(new Dictionary<string, object>()
                        {
                            ["gateway"] = new Dictionary<string, object>()
                            {
                                ["restAuthCredential.isEnabled"] = "true",
                                ["restAuthCredential.password"] = "**********",
                                ["restAuthCredential.username"] = "admin"
                            }
                        }),
                    },
                    ComputeRoles =
{
new HDInsightClusterRole()
{
Name = "headnode",
TargetInstanceCount = 2,
HardwareVmSize = "Large",
OSLinuxProfile = new HDInsightLinuxOSProfile()
{
Username = "sshuser",
Password = "**********",
},
},new HDInsightClusterRole()
{
Name = "workernode",
TargetInstanceCount = 3,
HardwareVmSize = "Large",
OSLinuxProfile = new HDInsightLinuxOSProfile()
{
Username = "sshuser",
Password = "**********",
},
},new HDInsightClusterRole()
{
Name = "zookeepernode",
TargetInstanceCount = 3,
HardwareVmSize = "Small",
OSLinuxProfile = new HDInsightLinuxOSProfile()
{
Username = "sshuser",
Password = "**********",
},
}
},
                    StorageAccounts =
{
new HDInsightStorageAccountInfo()
{
Name = "mystorage.blob.core.windows.net",
IsDefault = true,
Container = "default8525",
Key = "storagekey",
EnableSecureChannel = true,
}
},
                    MinSupportedTlsVersion = "1.2",
                },
            };
            ArmOperation<HDInsightClusterResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, clusterName, content);
            HDInsightClusterResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            HDInsightClusterData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create cluster with availability zones
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateClusterWithAvailabilityZones()
        {
            // Generated from example definition: specification/hdinsight/resource-manager/Microsoft.HDInsight/preview/2024-08-01-preview/examples/CreateHDInsightClusterWithAvailabilityZones.json
            // this example is just showing the usage of "Clusters_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "subId";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this HDInsightClusterResource
            HDInsightClusterCollection collection = resourceGroupResource.GetHDInsightClusters();

            // invoke the operation
            string clusterName = "cluster1";
            HDInsightClusterCreateOrUpdateContent content = new HDInsightClusterCreateOrUpdateContent()
            {
                Zones =
{
"1"
},
                Properties = new HDInsightClusterCreateOrUpdateProperties()
                {
                    ClusterVersion = "3.6",
                    OSType = HDInsightOSType.Linux,
                    ClusterDefinition = new HDInsightClusterDefinition()
                    {
                        Kind = "hadoop",
                        Configurations = BinaryData.FromObjectAsJson(new Dictionary<string, object>()
                        {
                            ["ambari-conf"] = new Dictionary<string, object>()
                            {
                                ["database-name"] = "{ambari database name}",
                                ["database-server"] = "{sql server name}.database.windows.net",
                                ["database-user-name"] = "**********",
                                ["database-user-password"] = "**********"
                            },
                            ["gateway"] = new Dictionary<string, object>()
                            {
                                ["restAuthCredential.isEnabled"] = "true",
                                ["restAuthCredential.password"] = "**********",
                                ["restAuthCredential.username"] = "admin"
                            },
                            ["hive-env"] = new Dictionary<string, object>()
                            {
                                ["hive_database"] = "Existing MSSQL Server database with SQL authentication",
                                ["hive_database_name"] = "{hive metastore name}",
                                ["hive_database_type"] = "mssql",
                                ["hive_existing_mssql_server_database"] = "{hive metastore name}",
                                ["hive_existing_mssql_server_host"] = "{sql server name}.database.windows.net",
                                ["hive_hostname"] = "{sql server name}.database.windows.net"
                            },
                            ["hive-site"] = new Dictionary<string, object>()
                            {
                                ["javax.jdo.option.ConnectionDriverName"] = "com.microsoft.sqlserver.jdbc.SQLServerDriver",
                                ["javax.jdo.option.ConnectionPassword"] = "**********!",
                                ["javax.jdo.option.ConnectionURL"] = "jdbc:sqlserver://{sql server name}.database.windows.net;database={hive metastore name};encrypt=true;trustServerCertificate=true;create=false;loginTimeout=300;sendStringParametersAsUnicode=true;prepareSQL=0",
                                ["javax.jdo.option.ConnectionUserName"] = "**********"
                            },
                            ["oozie-env"] = new Dictionary<string, object>()
                            {
                                ["oozie_database"] = "Existing MSSQL Server database with SQL authentication",
                                ["oozie_database_name"] = "{oozie metastore name}",
                                ["oozie_database_type"] = "mssql",
                                ["oozie_existing_mssql_server_database"] = "{oozie metastore name}",
                                ["oozie_existing_mssql_server_host"] = "{sql server name}.database.windows.net",
                                ["oozie_hostname"] = "{sql server name}.database.windows.net"
                            },
                            ["oozie-site"] = new Dictionary<string, object>()
                            {
                                ["oozie.db.schema.name"] = "oozie",
                                ["oozie.service.JPAService.jdbc.driver"] = "com.microsoft.sqlserver.jdbc.SQLServerDriver",
                                ["oozie.service.JPAService.jdbc.password"] = "**********",
                                ["oozie.service.JPAService.jdbc.url"] = "jdbc:sqlserver://{sql server name}.database.windows.net;database={oozie metastore name};encrypt=true;trustServerCertificate=true;create=false;loginTimeout=300;sendStringParametersAsUnicode=true;prepareSQL=0",
                                ["oozie.service.JPAService.jdbc.username"] = "**********"
                            }
                        }),
                    },
                    ComputeRoles =
{
new HDInsightClusterRole()
{
Name = "headnode",
TargetInstanceCount = 2,
HardwareVmSize = "standard_d3",
OSLinuxProfile = new HDInsightLinuxOSProfile()
{
Username = "sshuser",
Password = "**********",
SshPublicKeys =
{
new HDInsightSshPublicKey()
{
CertificateData = "**********",
}
},
},
VirtualNetworkProfile = new HDInsightVirtualNetworkProfile()
{
Id = new ResourceIdentifier("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname"),
Subnet = "/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname/subnets/vnetsubnet",
},
},new HDInsightClusterRole()
{
Name = "workernode",
TargetInstanceCount = 2,
HardwareVmSize = "standard_d3",
OSLinuxProfile = new HDInsightLinuxOSProfile()
{
Username = "sshuser",
Password = "**********",
SshPublicKeys =
{
new HDInsightSshPublicKey()
{
CertificateData = "**********",
}
},
},
VirtualNetworkProfile = new HDInsightVirtualNetworkProfile()
{
Id = new ResourceIdentifier("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname"),
Subnet = "/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname/subnets/vnetsubnet",
},
}
},
                    StorageAccounts =
{
new HDInsightStorageAccountInfo()
{
Name = "mystorage",
IsDefault = true,
Container = "containername",
Key = "storage account key",
EnableSecureChannel = true,
}
},
                },
            };
            ArmOperation<HDInsightClusterResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, clusterName, content);
            HDInsightClusterResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            HDInsightClusterData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create cluster with compute isolation properties
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateClusterWithComputeIsolationProperties()
        {
            // Generated from example definition: specification/hdinsight/resource-manager/Microsoft.HDInsight/preview/2024-08-01-preview/examples/CreateHDInsightClusterWithComputeIsolationProperties.json
            // this example is just showing the usage of "Clusters_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "subId";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this HDInsightClusterResource
            HDInsightClusterCollection collection = resourceGroupResource.GetHDInsightClusters();

            // invoke the operation
            string clusterName = "cluster1";
            HDInsightClusterCreateOrUpdateContent content = new HDInsightClusterCreateOrUpdateContent()
            {
                Properties = new HDInsightClusterCreateOrUpdateProperties()
                {
                    ClusterVersion = "3.6",
                    OSType = HDInsightOSType.Linux,
                    ClusterDefinition = new HDInsightClusterDefinition()
                    {
                        Kind = "hadoop",
                        Configurations = BinaryData.FromObjectAsJson(new Dictionary<string, object>()
                        {
                            ["gateway"] = new Dictionary<string, object>()
                            {
                                ["restAuthCredential.isEnabled"] = "true",
                                ["restAuthCredential.password"] = "**********",
                                ["restAuthCredential.username"] = "admin"
                            }
                        }),
                    },
                    ComputeRoles =
{
new HDInsightClusterRole()
{
Name = "headnode",
TargetInstanceCount = 2,
HardwareVmSize = "standard_d3",
OSLinuxProfile = new HDInsightLinuxOSProfile()
{
Username = "sshuser",
Password = "**********",
SshPublicKeys =
{
new HDInsightSshPublicKey()
{
CertificateData = "**********",
}
},
},
},new HDInsightClusterRole()
{
Name = "workernode",
TargetInstanceCount = 2,
HardwareVmSize = "standard_d3",
OSLinuxProfile = new HDInsightLinuxOSProfile()
{
Username = "sshuser",
Password = "**********",
SshPublicKeys =
{
new HDInsightSshPublicKey()
{
CertificateData = "**********",
}
},
},
}
},
                    StorageAccounts =
{
new HDInsightStorageAccountInfo()
{
Name = "mystorage",
IsDefault = true,
Container = "containername",
Key = "storage account key",
EnableSecureChannel = true,
}
},
                    ComputeIsolationProperties = new HDInsightComputeIsolationProperties()
                    {
                        EnableComputeIsolation = true,
                        HostSku = null,
                    },
                },
            };
            ArmOperation<HDInsightClusterResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, clusterName, content);
            HDInsightClusterResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            HDInsightClusterData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create cluster with encryption at host
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateClusterWithEncryptionAtHost()
        {
            // Generated from example definition: specification/hdinsight/resource-manager/Microsoft.HDInsight/preview/2024-08-01-preview/examples/CreateHDInsightClusterWithEncryptionAtHost.json
            // this example is just showing the usage of "Clusters_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this HDInsightClusterResource
            HDInsightClusterCollection collection = resourceGroupResource.GetHDInsightClusters();

            // invoke the operation
            string clusterName = "cluster1";
            HDInsightClusterCreateOrUpdateContent content = new HDInsightClusterCreateOrUpdateContent()
            {
                Properties = new HDInsightClusterCreateOrUpdateProperties()
                {
                    ClusterVersion = "3.6",
                    OSType = HDInsightOSType.Linux,
                    Tier = HDInsightTier.Standard,
                    ClusterDefinition = new HDInsightClusterDefinition()
                    {
                        Kind = "Hadoop",
                        Configurations = BinaryData.FromObjectAsJson(new Dictionary<string, object>()
                        {
                            ["gateway"] = new Dictionary<string, object>()
                            {
                                ["restAuthCredential.isEnabled"] = "true",
                                ["restAuthCredential.password"] = "**********",
                                ["restAuthCredential.username"] = "admin"
                            }
                        }),
                    },
                    ComputeRoles =
{
new HDInsightClusterRole()
{
Name = "headnode",
TargetInstanceCount = 2,
HardwareVmSize = "Standard_DS14_v2",
OSLinuxProfile = new HDInsightLinuxOSProfile()
{
Username = "sshuser",
Password = "**********",
},
},new HDInsightClusterRole()
{
Name = "workernode",
TargetInstanceCount = 3,
HardwareVmSize = "Standard_DS14_v2",
OSLinuxProfile = new HDInsightLinuxOSProfile()
{
Username = "sshuser",
Password = "**********",
},
},new HDInsightClusterRole()
{
Name = "zookeepernode",
TargetInstanceCount = 3,
HardwareVmSize = "Standard_DS14_v2",
OSLinuxProfile = new HDInsightLinuxOSProfile()
{
Username = "sshuser",
Password = "**********",
},
}
},
                    StorageAccounts =
{
new HDInsightStorageAccountInfo()
{
Name = "mystorage.blob.core.windows.net",
IsDefault = true,
Container = "default8525",
Key = "storagekey",
EnableSecureChannel = true,
}
},
                    DiskEncryptionProperties = new HDInsightDiskEncryptionProperties()
                    {
                        IsEncryptionAtHostEnabled = true,
                    },
                },
            };
            ArmOperation<HDInsightClusterResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, clusterName, content);
            HDInsightClusterResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            HDInsightClusterData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create cluster with encryption in transit
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateClusterWithEncryptionInTransit()
        {
            // Generated from example definition: specification/hdinsight/resource-manager/Microsoft.HDInsight/preview/2024-08-01-preview/examples/CreateHDInsightClusterWithEncryptionInTransit.json
            // this example is just showing the usage of "Clusters_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this HDInsightClusterResource
            HDInsightClusterCollection collection = resourceGroupResource.GetHDInsightClusters();

            // invoke the operation
            string clusterName = "cluster1";
            HDInsightClusterCreateOrUpdateContent content = new HDInsightClusterCreateOrUpdateContent()
            {
                Properties = new HDInsightClusterCreateOrUpdateProperties()
                {
                    ClusterVersion = "3.6",
                    OSType = HDInsightOSType.Linux,
                    Tier = HDInsightTier.Standard,
                    ClusterDefinition = new HDInsightClusterDefinition()
                    {
                        Kind = "Hadoop",
                        Configurations = BinaryData.FromObjectAsJson(new Dictionary<string, object>()
                        {
                            ["gateway"] = new Dictionary<string, object>()
                            {
                                ["restAuthCredential.isEnabled"] = "true",
                                ["restAuthCredential.password"] = "**********",
                                ["restAuthCredential.username"] = "admin"
                            }
                        }),
                    },
                    ComputeRoles =
{
new HDInsightClusterRole()
{
Name = "headnode",
TargetInstanceCount = 2,
HardwareVmSize = "Large",
OSLinuxProfile = new HDInsightLinuxOSProfile()
{
Username = "sshuser",
Password = "**********",
},
},new HDInsightClusterRole()
{
Name = "workernode",
TargetInstanceCount = 3,
HardwareVmSize = "Large",
OSLinuxProfile = new HDInsightLinuxOSProfile()
{
Username = "sshuser",
Password = "**********",
},
},new HDInsightClusterRole()
{
Name = "zookeepernode",
TargetInstanceCount = 3,
HardwareVmSize = "Small",
OSLinuxProfile = new HDInsightLinuxOSProfile()
{
Username = "sshuser",
Password = "**********",
},
}
},
                    StorageAccounts =
{
new HDInsightStorageAccountInfo()
{
Name = "mystorage.blob.core.windows.net",
IsDefault = true,
Container = "default8525",
Key = "storagekey",
EnableSecureChannel = true,
}
},
                    IsEncryptionInTransitEnabled = true,
                },
            };
            ArmOperation<HDInsightClusterResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, clusterName, content);
            HDInsightClusterResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            HDInsightClusterData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create cluster with network properties
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateClusterWithNetworkProperties()
        {
            // Generated from example definition: specification/hdinsight/resource-manager/Microsoft.HDInsight/preview/2024-08-01-preview/examples/CreateHDInsightClusterWithCustomNetworkProperties.json
            // this example is just showing the usage of "Clusters_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "subId";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this HDInsightClusterResource
            HDInsightClusterCollection collection = resourceGroupResource.GetHDInsightClusters();

            // invoke the operation
            string clusterName = "cluster1";
            HDInsightClusterCreateOrUpdateContent content = new HDInsightClusterCreateOrUpdateContent()
            {
                Properties = new HDInsightClusterCreateOrUpdateProperties()
                {
                    ClusterVersion = "3.6",
                    OSType = HDInsightOSType.Linux,
                    ClusterDefinition = new HDInsightClusterDefinition()
                    {
                        Kind = "hadoop",
                        Configurations = BinaryData.FromObjectAsJson(new Dictionary<string, object>()
                        {
                            ["gateway"] = new Dictionary<string, object>()
                            {
                                ["restAuthCredential.isEnabled"] = "true",
                                ["restAuthCredential.password"] = "**********",
                                ["restAuthCredential.username"] = "admin"
                            }
                        }),
                    },
                    ComputeRoles =
{
new HDInsightClusterRole()
{
Name = "headnode",
TargetInstanceCount = 2,
HardwareVmSize = "standard_d3",
OSLinuxProfile = new HDInsightLinuxOSProfile()
{
Username = "sshuser",
Password = "**********",
SshPublicKeys =
{
new HDInsightSshPublicKey()
{
CertificateData = "**********",
}
},
},
VirtualNetworkProfile = new HDInsightVirtualNetworkProfile()
{
Id = new ResourceIdentifier("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname"),
Subnet = "/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname/subnets/vnetsubnet",
},
},new HDInsightClusterRole()
{
Name = "workernode",
TargetInstanceCount = 2,
HardwareVmSize = "standard_d3",
OSLinuxProfile = new HDInsightLinuxOSProfile()
{
Username = "sshuser",
Password = "**********",
SshPublicKeys =
{
new HDInsightSshPublicKey()
{
CertificateData = "**********",
}
},
},
VirtualNetworkProfile = new HDInsightVirtualNetworkProfile()
{
Id = new ResourceIdentifier("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname"),
Subnet = "/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname/subnets/vnetsubnet",
},
}
},
                    StorageAccounts =
{
new HDInsightStorageAccountInfo()
{
Name = "mystorage",
IsDefault = true,
Container = "containername",
Key = "storage account key",
EnableSecureChannel = true,
}
},
                    NetworkProperties = new HDInsightClusterNetworkProperties()
                    {
                        ResourceProviderConnection = HDInsightResourceProviderConnection.Outbound,
                        PrivateLink = HDInsightPrivateLinkState.Enabled,
                        PublicIPTag = new HDInsightClusterIPTag("FirstPartyUsage", "/<TagName>"),
                    },
                },
            };
            ArmOperation<HDInsightClusterResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, clusterName, content);
            HDInsightClusterResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            HDInsightClusterData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get Hadoop on Linux cluster
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetHadoopOnLinuxCluster()
        {
            // Generated from example definition: specification/hdinsight/resource-manager/Microsoft.HDInsight/preview/2024-08-01-preview/examples/GetLinuxHadoopCluster.json
            // this example is just showing the usage of "Clusters_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this HDInsightClusterResource
            HDInsightClusterCollection collection = resourceGroupResource.GetHDInsightClusters();

            // invoke the operation
            string clusterName = "cluster1";
            HDInsightClusterResource result = await collection.GetAsync(clusterName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            HDInsightClusterData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get Hadoop on Linux cluster
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetHadoopOnLinuxCluster()
        {
            // Generated from example definition: specification/hdinsight/resource-manager/Microsoft.HDInsight/preview/2024-08-01-preview/examples/GetLinuxHadoopCluster.json
            // this example is just showing the usage of "Clusters_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this HDInsightClusterResource
            HDInsightClusterCollection collection = resourceGroupResource.GetHDInsightClusters();

            // invoke the operation
            string clusterName = "cluster1";
            bool result = await collection.ExistsAsync(clusterName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get Hadoop on Linux cluster
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetHadoopOnLinuxCluster()
        {
            // Generated from example definition: specification/hdinsight/resource-manager/Microsoft.HDInsight/preview/2024-08-01-preview/examples/GetLinuxHadoopCluster.json
            // this example is just showing the usage of "Clusters_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this HDInsightClusterResource
            HDInsightClusterCollection collection = resourceGroupResource.GetHDInsightClusters();

            // invoke the operation
            string clusterName = "cluster1";
            NullableResponse<HDInsightClusterResource> response = await collection.GetIfExistsAsync(clusterName);
            HDInsightClusterResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                HDInsightClusterData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Get Spark on Linux cluster
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetSparkOnLinuxCluster()
        {
            // Generated from example definition: specification/hdinsight/resource-manager/Microsoft.HDInsight/preview/2024-08-01-preview/examples/GetLinuxSparkCluster.json
            // this example is just showing the usage of "Clusters_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this HDInsightClusterResource
            HDInsightClusterCollection collection = resourceGroupResource.GetHDInsightClusters();

            // invoke the operation
            string clusterName = "cluster1";
            HDInsightClusterResource result = await collection.GetAsync(clusterName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            HDInsightClusterData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get Spark on Linux cluster
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetSparkOnLinuxCluster()
        {
            // Generated from example definition: specification/hdinsight/resource-manager/Microsoft.HDInsight/preview/2024-08-01-preview/examples/GetLinuxSparkCluster.json
            // this example is just showing the usage of "Clusters_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this HDInsightClusterResource
            HDInsightClusterCollection collection = resourceGroupResource.GetHDInsightClusters();

            // invoke the operation
            string clusterName = "cluster1";
            bool result = await collection.ExistsAsync(clusterName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get Spark on Linux cluster
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetSparkOnLinuxCluster()
        {
            // Generated from example definition: specification/hdinsight/resource-manager/Microsoft.HDInsight/preview/2024-08-01-preview/examples/GetLinuxSparkCluster.json
            // this example is just showing the usage of "Clusters_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this HDInsightClusterResource
            HDInsightClusterCollection collection = resourceGroupResource.GetHDInsightClusters();

            // invoke the operation
            string clusterName = "cluster1";
            NullableResponse<HDInsightClusterResource> response = await collection.GetIfExistsAsync(clusterName);
            HDInsightClusterResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                HDInsightClusterData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Get All Hadoop on Linux clusters in a resource group
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_GetAllHadoopOnLinuxClustersInAResourceGroup()
        {
            // Generated from example definition: specification/hdinsight/resource-manager/Microsoft.HDInsight/preview/2024-08-01-preview/examples/GetLinuxHadoopAllClustersInResourceGroup.json
            // this example is just showing the usage of "Clusters_ListByResourceGroup" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this HDInsightClusterResource
            HDInsightClusterCollection collection = resourceGroupResource.GetHDInsightClusters();

            // invoke the operation and iterate over the result
            await foreach (HDInsightClusterResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                HDInsightClusterData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
