// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HardwareSecurityModules.Models
{
    /// <summary> State of security domain activation. </summary>
    public readonly partial struct SecurityDomainActivationState : IEquatable<SecurityDomainActivationState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SecurityDomainActivationState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SecurityDomainActivationState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotDefinedValue = "NotDefined";
        private const string NotActivatedValue = "NotActivated";
        private const string ActiveValue = "Active";
        private const string FailedValue = "Failed";
        private const string UnknownValue = "Unknown";

        /// <summary> NotDefined. </summary>
        public static SecurityDomainActivationState NotDefined { get; } = new SecurityDomainActivationState(NotDefinedValue);
        /// <summary> NotActivated. </summary>
        public static SecurityDomainActivationState NotActivated { get; } = new SecurityDomainActivationState(NotActivatedValue);
        /// <summary> Active. </summary>
        public static SecurityDomainActivationState Active { get; } = new SecurityDomainActivationState(ActiveValue);
        /// <summary> Failed. </summary>
        public static SecurityDomainActivationState Failed { get; } = new SecurityDomainActivationState(FailedValue);
        /// <summary> Unknown. </summary>
        public static SecurityDomainActivationState Unknown { get; } = new SecurityDomainActivationState(UnknownValue);
        /// <summary> Determines if two <see cref="SecurityDomainActivationState"/> values are the same. </summary>
        public static bool operator ==(SecurityDomainActivationState left, SecurityDomainActivationState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SecurityDomainActivationState"/> values are not the same. </summary>
        public static bool operator !=(SecurityDomainActivationState left, SecurityDomainActivationState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SecurityDomainActivationState"/>. </summary>
        public static implicit operator SecurityDomainActivationState(string value) => new SecurityDomainActivationState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SecurityDomainActivationState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SecurityDomainActivationState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
