// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.HardwareSecurityModules.Models
{
    /// <summary> The network profile definition. </summary>
    public partial class DedicatedHsmNetworkProfile
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DedicatedHsmNetworkProfile"/>. </summary>
        public DedicatedHsmNetworkProfile()
        {
            NetworkInterfaces = new ChangeTrackingList<DedicatedHsmNetworkInterface>();
        }

        /// <summary> Initializes a new instance of <see cref="DedicatedHsmNetworkProfile"/>. </summary>
        /// <param name="subnet"> Specifies the identifier of the subnet. </param>
        /// <param name="networkInterfaces"> Specifies the list of resource Ids for the network interfaces associated with the dedicated HSM. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DedicatedHsmNetworkProfile(ApiEntityReference subnet, IList<DedicatedHsmNetworkInterface> networkInterfaces, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Subnet = subnet;
            NetworkInterfaces = networkInterfaces;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Specifies the identifier of the subnet. </summary>
        internal ApiEntityReference Subnet { get; set; }
        /// <summary> The Azure resource id in the form of /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/... </summary>
        [WirePath("subnet.resourceId")]
        public ResourceIdentifier SubnetResourceId
        {
            get => Subnet is null ? default : Subnet.ResourceId;
            set
            {
                if (Subnet is null)
                    Subnet = new ApiEntityReference();
                Subnet.ResourceId = value;
            }
        }

        /// <summary> Specifies the list of resource Ids for the network interfaces associated with the dedicated HSM. </summary>
        [WirePath("networkInterfaces")]
        public IList<DedicatedHsmNetworkInterface> NetworkInterfaces { get; }
    }
}
