// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HardwareSecurityModules.Models
{
    /// <summary> A domain name that dedicated hsm services are reaching at. </summary>
    public partial class DedicatedHsmEndpointDependency
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DedicatedHsmEndpointDependency"/>. </summary>
        internal DedicatedHsmEndpointDependency()
        {
            EndpointDetails = new ChangeTrackingList<DedicatedHsmEndpointDetail>();
        }

        /// <summary> Initializes a new instance of <see cref="DedicatedHsmEndpointDependency"/>. </summary>
        /// <param name="domainName"> The domain name of the dependency. </param>
        /// <param name="endpointDetails"> The Ports and Protocols used when connecting to domainName. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DedicatedHsmEndpointDependency(string domainName, IReadOnlyList<DedicatedHsmEndpointDetail> endpointDetails, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DomainName = domainName;
            EndpointDetails = endpointDetails;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The domain name of the dependency. </summary>
        [WirePath("domainName")]
        public string DomainName { get; }
        /// <summary> The Ports and Protocols used when connecting to domainName. </summary>
        [WirePath("endpointDetails")]
        public IReadOnlyList<DedicatedHsmEndpointDetail> EndpointDetails { get; }
    }
}
