// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HardwareSecurityModules.Models
{
    /// <summary> The Cloud HSM Properties. </summary>
    public partial class CloudHsmProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CloudHsmProperties"/>. </summary>
        internal CloudHsmProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="CloudHsmProperties"/>. </summary>
        /// <param name="fqdn"> FQDN of the Cloud HSM. </param>
        /// <param name="state"> The Cloud HSM State. Values are: Deploying, ConfiguringSlb, Starting, Starting, Failed, Failed, Deleting, DeletingSlbEntry, InitialProvisioning, Updating. </param>
        /// <param name="stateMessage"> The Cloud HSM State message. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CloudHsmProperties(string fqdn, string state, string stateMessage, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Fqdn = fqdn;
            State = state;
            StateMessage = stateMessage;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> FQDN of the Cloud HSM. </summary>
        [WirePath("fqdn")]
        public string Fqdn { get; }
        /// <summary> The Cloud HSM State. Values are: Deploying, ConfiguringSlb, Starting, Starting, Failed, Failed, Deleting, DeletingSlbEntry, InitialProvisioning, Updating. </summary>
        [WirePath("state")]
        public string State { get; }
        /// <summary> The Cloud HSM State message. </summary>
        [WirePath("stateMessage")]
        public string StateMessage { get; }
    }
}
