// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HardwareSecurityModules.Models
{
    /// <summary> The Cloud HSM Cluster public network access. </summary>
    public readonly partial struct CloudHsmClusterPublicNetworkAccess : IEquatable<CloudHsmClusterPublicNetworkAccess>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CloudHsmClusterPublicNetworkAccess"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CloudHsmClusterPublicNetworkAccess(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DisabledValue = "Disabled";

        /// <summary> Disabled. </summary>
        public static CloudHsmClusterPublicNetworkAccess Disabled { get; } = new CloudHsmClusterPublicNetworkAccess(DisabledValue);
        /// <summary> Determines if two <see cref="CloudHsmClusterPublicNetworkAccess"/> values are the same. </summary>
        public static bool operator ==(CloudHsmClusterPublicNetworkAccess left, CloudHsmClusterPublicNetworkAccess right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CloudHsmClusterPublicNetworkAccess"/> values are not the same. </summary>
        public static bool operator !=(CloudHsmClusterPublicNetworkAccess left, CloudHsmClusterPublicNetworkAccess right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CloudHsmClusterPublicNetworkAccess"/>. </summary>
        public static implicit operator CloudHsmClusterPublicNetworkAccess(string value) => new CloudHsmClusterPublicNetworkAccess(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CloudHsmClusterPublicNetworkAccess other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CloudHsmClusterPublicNetworkAccess other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
